/*
 * July 5, 1991
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * Lance Norskog And Sundry Contributors are not responsible for 
 * the consequences of using this software.
 */

/*
 * CD-R format handler
 *
 * David Elliott, Sony Microsystems
 *
 * This code automatically handles endianness differences
 */

#include "st.h"

#define SECTORSIZE	(2352 / 2)

/* Private data for SKEL file */
typedef struct cdrstuff {
	int	samples;	/* number of samples written */
} *cdr_t;

/*
 * Do anything required before you start reading samples.
 * Read file header. 
 *	Find out sampling rate, 
 *	size and style of samples, 
 *	mono/stereo/quad.
 */

int cdrstartread(ft_t ft) 
{

	int     littlendian = 1;
	char    *endptr;

	endptr = (char *) &littlendian;
	if (!*endptr) ft->swap = 1;

	ft->info.rate = 44100;
	ft->info.size = WORD;
	ft->info.style = SIGN2;
	ft->info.channels = 2;
	ft->comment = NULL;
	
	return 1;
}

/*
 * Read up to len samples from file.
 * Convert to signed longs.
 * Place in buf[].
 * Return number of samples read.
 */

cdrread(ft_t ft, long *buf, int len) 
{
	return rawread(ft, buf, len);
}

/*
 * Do anything required when you stop reading samples.  
 * Don't close input file! 
 */
cdrstopread(ft_t ft) 
{
}

