/*
 * FourthApp
 * Is what is says
 * By Roberto J Peon
  */
  
#pragma once 
 #include <Application.h>
 #include <Button.h>
 #include <StringView.h>
 #include <Window.h>
 
 #define BUTTON_MSG 'bmsg'
 #define MOUSE_DN_MSG 'm dn'
 #define MOUSE_MOVED_MSG 'm mv'
 #define MOUSE_UP_MSG 'm up'

//**************************************

class FourthApp: public BApplication{
	public:
	FourthApp();
	virtual void RefsReceived(BMessage *message);
	BWindow *fourthWindow;
};

//**************************************

class FourthWindow : public BWindow{
	public:
	FourthWindow(BRect frame);
	virtual bool QuitRequested();
};

//**************************************

class FourthView: public BView{
	static int32 MouseDownThread(void* arg);
	public:
	FourthView(BRect frame, const char* name);
	virtual void MessageReceived(BMessage *message);
	virtual void MouseDown(BPoint);
};

//**************************************

void ErrorExit(char* str);
void ErrorExit(char* str){
	BAlert	*alert=new BAlert("Error", str, "Quit");
	alert->Go();
	exit(0);
}

//**************************************

FourthApp::FourthApp():BApplication("application/x-ama.RJP.FourthApp"){
	BRect aRect;
	aRect.Set(200,200,700,300);
	fourthWindow= new FourthWindow(aRect);
	if(!fourthWindow)
		ErrorExit("Couldn't new fourthWindow.");
	fourthWindow->Show();
}
//**************************************
void FourthApp::RefsReceived(BMessage *message){
	entry_ref ref;
	if(message->FindRef("refs",&ref)!=B_OK)
		ErrorExit("Couldn't FindRef \"refs\" in message");
	if(B_OK!=(fourthWindow->Lock()))
		ErrorExit("Couldn't Lock() fourthWindow.");
	BView *view=fourthWindow->ChildAt(0);
	if(view==NULL)
		ErrorExit("ChildAt() returned NULL when it shouldn't have.");
	fourthWindow->Unlock();
	if(B_OK!=(fourthWindow->PostMessage(message,view)))
		ErrorExit("Couldn't PostMessage() from fourthWindow.");
}
//**************************************

FourthWindow::FourthWindow(BRect frame)
	:BWindow(frame,"FourthApp",B_TITLED_WINDOW , 0){
	BRect aRect;
	FourthView *fourthView = new FourthView(Bounds(),"FourthBut!");
	if(!fourthView)
		ErrorExit("Couldn't new fourthView.");
	AddChild(fourthView);
}

//**************************************

bool FourthWindow::QuitRequested(){
	if(B_OK!=(be_app->PostMessage(B_QUIT_REQUESTED)))
		ErrorExit("Couldn't PostMessage to be_app.");
	return true;
}

//**************************************

FourthView::FourthView(BRect rect, const char* name)
	: BView(rect,name,B_FOLLOW_ALL,B_WILL_DRAW|B_SUBPIXEL_PRECISE){
}

//**************************************

void FourthView::MessageReceived(BMessage *message){
	static BPoint opt;
	message->PrintToStream();
	entry_ref ref;
	switch (message->what){
		case B_SIMPLE_DATA:
			if(message->FindRef("refs",&ref)==B_OK){
				//SetText(ref.name);
			}else{
				//BStringView::MessageReceived(message);
			}
			break;
		//case BUTTON_MSG:
		//	SetText( message->FindString("text"));
		//	break;
		case MOUSE_DN_MSG:
			if(B_OK!=(message->FindPoint("point",&opt)))
				ErrorExit("Couldn't FindPoint \"point\" in message.");
			break;
		case MOUSE_MOVED_MSG:
		{
			uint32 buttonStats;
			BPoint pt;
			if(B_OK!=(message->FindInt32("buttons",(int32)&buttonStats)))
				ErrorExit("Couldn't FindInt32 \"buttons\" in message.");
			if(B_OK!=(message->FindPoint("point",&pt)))
				ErrorExit("Couldn't FindPoint \"point\" in message.");
			if(opt!=pt){
				StrokeLine(opt,pt);
			}
			opt=pt;
		}
			break;
		default:
			BView::MessageReceived(message);
			break;
	}
}


//**************************************
int32 FourthView::MouseDownThread(void* arg){
	FourthView *ths=(FourthView*)arg;
	BPoint pt;
	uint32 buttonStats;
	if(ths->Window()->Lock()==false)
		ErrorExit("Couldn't Lock() Window().");
	if(B_OK!=(ths->Window()->CurrentMessage()->FindInt32("buttons",(int32)&buttonStats)))
		ErrorExit("Couldn't FindInt32 \"buttons\"");
	ths->Window()->Unlock();
	while(buttonStats!=0){
		BMessage *message=new BMessage(MOUSE_MOVED_MSG);
		if(!message) ErrorExit("Couldn't new message.");
		snooze(10000);	// minimum recommended wait time- mouse can ...
						// ...only move so far in so little time...
		if(ths->Window()->Lock()==false)
			ErrorExit("Couldn't Lock() Window().");
		ths->GetMouse(&pt,&buttonStats,true);
		if(B_OK!=(message->AddPoint("point",pt)))
			ErrorExit("Couldn't AddPoint \"point\".");
		if(B_OK!=(message->AddInt32("buttons",(int32)buttonStats)))
			ErrorExit("Couldn't AddInt32 \"buttons\".");
		if(B_OK!=(ths->Window()->PostMessage(message,ths)))
			ErrorExit("Couldn't PostMessage to Window().");
		ths->Window()->Unlock();
		free(message);
	}
	BMessage *message= new BMessage(MOUSE_UP_MSG);
	if(ths->Window()->Lock()==false)
		ErrorExit("Couldn't Lock() Window().");
	ths->GetMouse(&pt,&buttonStats,true);
	if(B_OK!=(message->AddPoint("point",pt)))
		ErrorExit("Couldn't AddPoint \"point\" to message.");
	if(B_OK!=(message->AddInt32("buttons",(int32)buttonStats)))
		ErrorExit("Couldn't AddInt32 \"buttons\" to message.");
	if(B_OK!=(ths->Window()->PostMessage(message,ths)))
		ErrorExit("Couldn't PostMessage to Window().");
	ths->Window()->Unlock();
	free(message);
	return 0;
}

//**************************************

void FourthView::MouseDown(BPoint pt){
	BMessage * message=new BMessage(MOUSE_DN_MSG);
	if(!message) ErrorExit("Couldn't new message.");
	uint32 buttonStats;
	thread_id mouseThread;
	if(B_OK!=(Window()->CurrentMessage()->FindInt32("buttons",(int32)&buttonStats)))
		ErrorExit("Couldn't FindInt32 \"buttons\"field in CurrentMessage...");
	if(B_OK!=(message->AddPoint("point",pt)))
		ErrorExit("Couldn't AddPoint \"point\" to message.");
	if(B_OK!=(message->AddInt32("buttons",(int32)buttonStats)))
		ErrorExit("Couldn't AddInt32 \"buttons\" to message.");
	if(B_OK!=(Window()->PostMessage(message,this)))
		ErrorExit("Couldn't PostMessage to Window().");
	free(message);
	if((mouseThread=spawn_thread(MouseDownThread,"MouseDownThread",B_URGENT_PRIORITY,this))<0){
		ErrorExit("Error spawning MouseDownThread.");
	}else{
		if(resume_thread(mouseThread)!=B_NO_ERROR){
			ErrorExit("Error resuming spawned MouseDownThread.");
		}
	}
}

//**************************************

int main(void)
{
/*	BApplication		app("application/x-whatever");
	
	BAlert	*alert=new BAlert("hello", "Hello World!", "OK");
	//BAlert alert("hello", "Hello World!", "OK");
	alert->Go();
*/
	FourthApp fourthApp;
	fourthApp.Run();	
	return 0;
}

