//functions of MyPopUpMenu

#include <memory>
#include "myPopUpMenu.h"
#include "warning.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myApp.h"


MyPopUpMenu	::	~MyPopUpMenu() 
{
//left blank
//pmList deletd in Initialize()
};//end


//ctor--just initialize
MyPopUpMenu	::	MyPopUpMenu(	const char *	ccpparamName, 
								const char *	ccpparamTitle, 
								BList *			pparamList,
								bool			bparamIsRadioMode) 
			: 
				BMenuBar(	BRect(0, 0, 32, 32), 
							ccpparamName, 
							B_FOLLOW_NONE),
				pmList(pparamList),
				pmTitle(ccpparamTitle),
				fmWidest(0),
				fmHeight(0),
				bmIsRadioMode(bparamIsRadioMode)
{
//left blank
}//end


//do all the real work of construction so we can fail gracefully
bool 
MyPopUpMenu	::	Initialize(	void) 
{
	//sanity check:
	if (!pmList)
	{
		warning("Bad initialization of MyPopUpMenu, NULL param\n");
		return false;
	}
	int32 numItems = pmList->CountItems();
	if (!numItems) return true;
	try
	{
		auto_ptr<BPopUpMenu> apPopUpMenu(new BPopUpMenu(pmTitle));
		BPopUpMenu * bpum = apPopUpMenu.get();
		apPopUpMenu.release();
		AddItem(bpum);
		bpum->SetRadioMode(bmIsRadioMode);
		auto_ptr<BList> apMenuItemList(new BList(/*numItems*/));
		BList * pMenuItemList = apMenuItemList.get();
		for (uint32 i = 0; i < numItems; i++)
		{
			PopUpMenuData * pumd = (PopUpMenuData *)pmList->ItemAt(i);
			auto_ptr<BMessage> msg(new BMessage(pumd->ui32mMsg));
			auto_ptr<BMenuItem> apBMenuItem(new BMenuItem(pumd->ccpmLabel, msg.get()));
			msg.release();
			BMenuItem * bmi = apBMenuItem.get();
			apBMenuItem.release();
			bmi->SetMarked(false);//from paramlist??debug
			bpum->AddItem(bmi);
			pMenuItemList->AddItem((void *)pumd->ccpmLabel);
		}
		menu_info menuInfo;
		get_menu_info(&menuInfo);
		BWindow bw(	BRect(0, 0, 32, 32), 
					"noshow", 
					B_DOCUMENT_WINDOW, 
					/*B_WILL_ACCEPT_FIRST_CLICK*/0);
		BView view(BRect(0, 0, 32, 32), "popupmenu temp view", B_FOLLOW_NONE, B_WILL_DRAW);
		bw.AddChild(&view);
		BFont font;
		font.SetFamilyAndStyle(menuInfo.f_family, menuInfo.f_style);
		font.SetSize(menuInfo.font_size);
		view.SetFont(&font);
		font_height	fontHeight;
		view.GetFontHeight(&fontHeight);
		float pad = 4;
		float width;
		fmWidest = view.StringWidth(pmTitle); 
		fmHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading + pad;
		for (uint32 i = 0; i < numItems; i++)
		{
			const char * text = (const char *)pMenuItemList->ItemAt(i);
			width = view.StringWidth(text);
			if (width > fmWidest) 
			{
				fmWidest = width;
			}
		}
		view.RemoveSelf();
	}
	catch (...)
	{
		for (uint32 i = 0; i < numItems; i++)
		{
			PopUpMenuData * pumd = (PopUpMenuData *)pmList->ItemAt(i);
			delete pumd;
		}
		delete pmList;
		warning("New failed.\n");
		return false;
	}
	for (uint32 i = 0; i < numItems; i++)
	{
		PopUpMenuData * pumd = (PopUpMenuData *)pmList->ItemAt(i);
		delete pumd;
	}
	delete pmList;
	return true;
}//end


void
MyPopUpMenu	::	MyGetPreferredSize(	float * fpparamwidth,
									float * fpparamheight)
{
	*fpparamwidth = fmWidest;
	*fpparamheight = fmHeight;
}//end