//
//
//	Messages list
//
//								(C) Alain Gautherot 1999

#ifndef _MESSAGES_LIST_H_
#define _MESSAGES_LIST_H_

#include "HomerLibBuild.h"

#include <interface/ScrollView.h>
#include <interface/ListView.h>
#include "MessageListItem.h"


//---------------------------------------------------------
// Messages list view
//---------------------------------------------------------
class HOMER_LIB_SYMBOL	MessagesListView: public BListView
{
public:
	MessagesListView(BRect , const char* );
	virtual ~MessagesListView();

	int32				CountItems() const;
	MessageListItem*	ItemAt(int32 i) const;
	bool				AddItem(MessageListItem* );
	MessageListItem*	RemoveItem(int32 i);
};

//---------------------------------------------------------
// Messages list
//---------------------------------------------------------
class HOMER_LIB_SYMBOL	MessagesList: public BScrollView
{
	MessagesListView*	list;

public:
	MessagesList(MessagesListView* , const char* );
	virtual ~MessagesList();

	virtual void		AttachedToWindow();
//	virtual void		MessageReceived(BMessage* );

	bool				Insert(MessageListItem* );
	void				SelectAll();
	MessageListItem*	Remove(int32 );
	bool				Delete(int32 );
	void				DeleteAll();
	void				RemoveSelected();
};


#endif /* _MESSAGES_LIST_H_ */
