#ifndef HUSTLER_HUSTLER_APP_H
#define HUSTLER_HUSTLER_APP_H

// ***************************************************************************
// System Includes
// ***************************************************************************

#include <Application.h>

// ***************************************************************************
// Project Includes
// ***************************************************************************

#include "StyleGuideDefs.h"         // Standard type and constant definitions.

// ***************************************************************************
// External Name Declarations
// ***************************************************************************

// ***************************************************************************
// External Variable Declarations
// ***************************************************************************

// ***************************************************************************
// Constant Definitions
// ***************************************************************************

/** The MIME signature of our application. */
#define APP_SIGNATURE "application/x-vnd.mahlzeit.Hustler"

// ***************************************************************************
// Type Definitions
// ***************************************************************************

// ***************************************************************************
// Class Definition
// ***************************************************************************

/** 
 * The tHustlerApp class installs the Hustler replicant in the Deskbar.
 *
 * This class creates a tHustler object, archives it, and sends it to the 
 * Deskbar where it will be replicated. As soon as the replicant is sent, the
 * application will terminate itself.
 * 
 * Because the application only runs for about a second (probably less),
 * there is no need for its title to appear inside the Deskbar. Therefore, 
 * the application flags inside the resource file Hustler.rsrc should be set
 * to B_BACKGROUND_APP.
 * 
 * @author Matthijs Hollemans <mahlzeit@bigfoot.com>
 * @version 1.0 (Saturday, 20 March 1999)
 */
class tHustlerApp : public BApplication {
public:
  // Constant Definitions ====================================================

  // Type Definitions ========================================================

  // Attribute Definitions ===================================================

  // Member Function Definitions =============================================

  // Lifecycle ---------------------------------------------------------------

  /** Constructor. */
  tHustlerApp(void);

  /** Automatically generated copy constructor. */
  // tHustlerApp(const tHustlerApp& arOld);

  /** Automatically generated destructor. */
  // virtual ~tHustlerApp();

  // Operators ---------------------------------------------------------------

  /** Automatically generated assignment operator. */
  // tHustlerApp& operator=(tHustlerApp& arRight);

  // Operations --------------------------------------------------------------
      
  // Access ------------------------------------------------------------------

  // Inquiry -----------------------------------------------------------------

protected:
  // Constant Definitions ====================================================

  // Type Definitions ========================================================

  // Attribute Definitions ===================================================

  // Member Function Definitions =============================================

private:
  // Constant Definitions ====================================================

  // Type Definitions ========================================================

  // Attribute Definitions ===================================================

  // Member Function Definitions =============================================
};

// ***************************************************************************
// Global Variable Declarations
// ***************************************************************************

// ***************************************************************************
// Inline Function Definitions
// ***************************************************************************

// ***************************************************************************
// Helper Function Declarations
// ***************************************************************************

// ***************************************************************************
// Global Function Declarations
// ***************************************************************************

#endif // HUSTLER_HUSTLER_APP_H
