//scrolling title window

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <sys/types.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include <FilePanel.h>
#include <Path.h>
#include <TranslationKit.h>
#include "DtinySnooze.h"
#include "DnumSpecificWindows.h"
#include "Preferences.h"
#include "myPreferences.h"
#include "warning.h"
#include "windowGuts.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "myCheckBox.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myPopUpMenu.h"
#include "myPictureButton.h"
#include "myColorControl.h"
#include "myStatusBar.h"
#include "myRadioView.h"
#include "myTextView.h"
#include "mySpacer.h"
#include "DmenuMsg.h"
#include "myroColour.h"
#include "verify.h"
#include "ToolBox2TextEdWindow.h"
#include "ToolBox2ToolPaletteWindow.h"
#include "ToolBox2App.h"

BBitmap * FetchBitmap(char *filename);
//ctor
ToolPaletteWindow	::	ToolPaletteWindow(	BRect paramBound,
											const char * paramWindowTitle,
											const char * paramScrollViewName,
											const char * paramNamePrefFrame)
			: 
				WindowGuts(	paramBound, 
							paramWindowTitle, 
							paramScrollViewName,
							paramNamePrefFrame,
							myApp->AppSignature,
							myApp->mpPreferenceSet,
							false),
				mpButton0(NULL),
				mpButton1(NULL),
				mpButton2(NULL)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(myApp->FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{

		LayoutMatrix *	pButtonLayoutMatrix = new LayoutMatrix(BESTSIZE, 3, 1, this);//rows,columns
////////////////////////////////////////////////
		BPicture * pOnInfoPicture;
		BPicture * pOnDisabledInfoPicture;
		BPicture * pOffInfoPicture;
		BPicture * pOffDisabledInfoPicture;
		float totalHeight;
		float width;
		BWindow bwn(	BRect(0, 0, 32, 32), //manditory for BPicture
						NULL, 
						B_DOCUMENT_WINDOW, 
						0);
		{
			BView bv(BRect(0, 0, 32, 32), NULL, B_FOLLOW_NONE, NULL);
			bwn.AddChild(&bv);
			bv.BeginPicture(new BPicture);
			pOffDisabledInfoPicture = bv.EndPicture();
			bv.BeginPicture(new BPicture);
			pOnInfoPicture = bv.EndPicture();
			bv.BeginPicture(new BPicture);
			pOnDisabledInfoPicture = bv.EndPicture();
			
			bv.BeginPicture(new BPicture);
			rgb_color fill;
			BFont * font = new BFont(myPrefs->GetPreferredFont());
			float size = font->Size();
			size *= 1.8;
			font->SetSize(size);
			bv.SetFont(font);
			font_height	fontHeight;
			bv.GetFontHeight(&fontHeight);
			totalHeight = fontHeight.ascent;// + fontHeight.descent + fontHeight.leading;
			width = bv.StringWidth("?");
			fill.red = 220;
			fill.green = 220;
			fill.blue = 220;
			fill.alpha = 255;
			bv.SetHighColor(fill);
			bv.FillRect(BRect(0,0,width + 2,totalHeight + 2));
			fill.red = 0;
			fill.green = 0;
			fill.blue = 0;
			fill.alpha = 255;
			bv.SetHighColor(fill);
			bv.SetPenSize(2);
			bv.MovePenTo(1,fontHeight.ascent);
			bv.DrawString("?");
			pOffInfoPicture = bv.EndPicture();
			bv.RemoveSelf();
		}
		mpButton0 = new MyPictureButton(	BRect(0, 0, width + 2, totalHeight + 2),
											"infoButton", 
											pOffInfoPicture,
											pOnInfoPicture,
											pOffDisabledInfoPicture,
											pOnDisabledInfoPicture,
											'b0Ms',
											B_ONE_STATE_BUTTON,
											pButtonLayoutMatrix);
////////////////////////////////////////////////////
		BPicture * pOnXXPicture;
		BPicture * pOnDisabledXXPicture;
		BPicture * pOffXXPicture;
		BPicture * pOffDisabledXXPicture;
		BRect bitMapRect;
		float fButtonWidth = myApp->GetToolPaletteButtonWidth();
		float fButtonWHeight = myApp->GetToolPaletteButtonHeight();
		
		{
			BView bv(BRect(0, 0, 32, 32), NULL, B_FOLLOW_NONE, NULL);
			bwn.AddChild(&bv);
			bv.BeginPicture(new BPicture);
			pOffDisabledXXPicture = bv.EndPicture();
			bv.BeginPicture(new BPicture);
			pOnXXPicture = bv.EndPicture();
			bv.BeginPicture(new BPicture);
			pOnDisabledXXPicture = bv.EndPicture();
			
			BBitmap * bitMap = FetchBitmap("/boot/home/ToolBox2/button.JPG");
			bitMapRect = bitMap->Bounds();
			bv.BeginPicture(new BPicture);
			bv.DrawBitmap(bitMap, bitMapRect, BRect(0, 0, fButtonWidth, fButtonWHeight));
			pOffXXPicture = bv.EndPicture();
			bv.RemoveSelf();
		}
		mpButton1 = new MyPictureButton(	BRect(0, 0, fButtonWidth, fButtonWHeight),
											"XXButton", 
											pOffXXPicture,
											pOnXXPicture,
											pOffDisabledXXPicture,
											pOnDisabledXXPicture,
											'b1Ms',
											B_ONE_STATE_BUTTON,
											pButtonLayoutMatrix);
/////////////////////////////////////////////////////////////
		BPicture * pOnBMPicture;
		BPicture * pOnDisabledBMPicture;
		BPicture * pOffBMPicture;
		BPicture * pOffDisabledBMPicture;
		{
			BView bv(BRect(0, 0, 32, 32), NULL, B_FOLLOW_NONE, NULL);
			bwn.AddChild(&bv);
			bv.BeginPicture(new BPicture);
			pOffDisabledBMPicture = bv.EndPicture();
			bv.BeginPicture(new BPicture);
			pOnBMPicture = bv.EndPicture();
			bv.BeginPicture(new BPicture);
			pOnDisabledBMPicture = bv.EndPicture();

			BBitmap * bitMap = FetchBitmap("/boot/home/ToolBox2/A.JPG");
			bitMapRect = bitMap->Bounds();
			bv.BeginPicture(new BPicture);
			bv.DrawBitmap(bitMap, bitMapRect, BRect(0, 0, fButtonWidth, fButtonWHeight));
			pOffBMPicture = bv.EndPicture();
			bv.RemoveSelf();
		}
		mpButton2 = new MyPictureButton(	BRect(0, 0, fButtonWidth, fButtonWHeight),
											"BMButton", 
											pOffBMPicture,
											pOnBMPicture,
											pOffDisabledBMPicture,
											pOnDisabledBMPicture,
											'b2Ms',
											B_ONE_STATE_BUTTON,
											pButtonLayoutMatrix);
//////////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pButtonLayoutMatrix->Calc(0, 0, calc_sem);
	}
	catch (...)
	{
		warning(myApp->CaughtToolPaletteWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
}//end


//dtor
ToolPaletteWindow	::	~ToolPaletteWindow() 
{
	if (myApp->pTextEdWindow)
	{
		myApp->pTextEdWindow->pToolPaletteWindow = NULL;
	}
}//end


void
ToolPaletteWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case ABOUT_TOOLPALETTWINDOW:	
		{
			BString warn = myApp->AboutToolPaletteWindowMsg1;
			warn += myApp->AboutToolPaletteWindowMsg2;
			warn += myApp->AboutToolPaletteWindowMsg3;
			warning(warn.String());
		}
		break;
		case QUIT_APP:
			if (Verify(myApp->ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		case PREFSMSG:
			myPrefs->OpenPreferencesPanel();
		break;
		case BUTTON0_MSG:
			warning("first button");
		break;
		case BUTTON1_MSG:
			warning("second button");
		break;
		case BUTTON2_MSG:
			warning("third button");
		break;
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
ToolPaletteWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myApp->SetPreferredToolPaletteWindowRect(frame);
	return(WindowGuts::QuitRequested());
}//end


BBitmap *
FetchBitmap(	char * filename) 
{ 
	BFile file(filename, B_READ_ONLY); 
	BTranslatorRoster *roster = BTranslatorRoster::Default(); 
	BBitmapStream stream; 
	BBitmap *result = NULL; 
	if (	roster->Translate(	&file, 
								NULL, 
								NULL, 
								&stream, 
								B_TRANSLATOR_BITMAP) 
			< B_OK
		)
	{
		return NULL;
	}
	stream.DetachBitmap(&result); 
	return result; 
}