//mySpacer.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "mySpacer.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "warning.h"
#include "DnumSpecificWindows.h"
#include "Preferences.h"
#include "myPreferences.h"

MySpacer	::	MySpacer(	float fparamPreferredWidth,
							float fparamPreferredHeight,
							LayoutMatrix * lpparamLayoutMatrix,
							bool bparamSAMEFromWidest)
			:	fPreferredWidth(fparamPreferredWidth),
				fPreferredHeight(fparamPreferredHeight),
				bSAMEFromWidest(bparamSAMEFromWidest)
{
	//does not get added to children of layoutmatrix!
	try
	{
		LayoutMatrixItem * lmi = new LayoutMatrixItem(	(void *)this,
														lpparamLayoutMatrix,
														KIND_MYSPACER);
		lpparamLayoutMatrix->mpLayoutMatrixItems->AddItem((void *)lmi);
	}
	catch (...)
	{
		warning(myPrefs->FailMemory);
		return;
	}
}//end


MySpacer	::	~MySpacer()
{
	//left blank
}//end


void
MySpacer	::	ResizeTo(	const float fparamWidest,
							const float fparamTallest)
{
	if (bSAMEFromWidest)
	{
		fPreferredWidth = fparamWidest;
		fPreferredHeight = fparamTallest;
	}
}//end


void
MySpacer	::	MyGetPreferredSize(	float * fparamWidth,
									float * fparamHeight) const
{
	*fparamWidth = fPreferredWidth;
	*fparamHeight = fPreferredHeight;
}//end