//scrollView.cpp

#define BUILDING_LIB 1


#include <stdio.h>
#include <memory>
#include <SupportDefs.h>
//#include <string>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "scrollView.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "layoutMatrix.h"
#include "Preferences.h"
#include "myroColour.h"
#include "myPreferences.h"

ScrollView	::	ScrollView(	BRect area) 
			: 	BView(	area, 
						"target", 
						B_FOLLOW_ALL, 
						B_WILL_DRAW | B_FULL_UPDATE_ON_RESIZE),
				pmTextItemList(new BList()),
				pmStringViewList(new BList())
{
	//left blank
}//end


ScrollView	::	~ScrollView() 
{
	delete pmTextItemList;
	int32 numStringViewListItems = pmStringViewList->CountItems();
	for (	int32 i = 0;
			i < numStringViewListItems;
			i++)
	{
		MyStringDrawer * holpMyStringDrawer = (MyStringDrawer *)pmStringViewList->ItemAt(i);
		delete holpMyStringDrawer;
	}
	delete pmStringViewList;
}//end


void 
ScrollView	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end


void 
ScrollView	::	Draw(	BRect rect) 
{
	BView::Draw(rect);
	FillRect(Bounds());
	//need to learn how to DoForEach(), need to understand pointers to functions
	rgb_color originalHighColor(HighColor());
	rgb_color originalLowColor(LowColor());
	rgb_color originalViewColor(ViewColor());
	rgb_color newColor;
	myPrefs->GetPreferredMyStringDrawerHighColor(&newColor);
	SetHighColor(newColor);
	myPrefs->GetPreferredMyStringDrawerLowColor(&newColor);
	SetLowColor(newColor);
	myPrefs->GetPreferredMyStringDrawerViewColor(&newColor);
	SetViewColor(newColor);
	int32 numItems = pmTextItemList->CountItems();
	for (	int i = 0;
			i < numItems;
			i++)
	{
		TextItem * textItem = (TextItem *)pmTextItemList->ItemAt(i);
		MovePenTo(textItem->left, textItem->top);
		DrawString(textItem->text);
	}
	numItems = pmStringViewList->CountItems();
	if (numItems)
	{
		for (	int i = 0;
				i < numItems;
				i++)
		{
			MyStringDrawer * myStringDrawer = (MyStringDrawer *)pmStringViewList->ItemAt(i);
			TextItem * textItem = myStringDrawer->GetTextItem();
			SetFont(myStringDrawer->GetFont());
			MovePenTo(textItem->left, textItem->top);
			DrawString(textItem->text);
		}
	}
	SetHighColor(originalHighColor);
	SetLowColor(originalLowColor);
	SetViewColor(originalViewColor);
}//end