//============================================================================
// AddOnConfigWindow.cpp
// © Michael Pieper 21. Mar. 1999
//============================================================================
//
//	This class manages the add-ons ConfigWindow.
//  It places the View from the Add-on in its window
//
//============================================================================

#include "AddOnConfigWindow.h"
#include <InterfaceKit.h>
#include <stdio.h>

//============================================================================
// Constructor for the ConfigWindow
// 

AddOnConfigWindow::AddOnConfigWindow(BRect frame, char *title, image_id img_id)
				: BWindow(frame, title, B_FLOATING_WINDOW_LOOK, B_MODAL_APP_WINDOW_FEEL, B_NOT_ZOOMABLE )

{
	status_t	result;
	BView		*addOnView;
	BRect		r = frame;
	float		w, h;
	
	result = get_image_symbol(img_id, "ConfigView", B_SYMBOL_TYPE_TEXT, (void **)&AddOnView);	// Get the RunServer()-Adress
	if (result == B_OK) {
		frame.OffsetTo(0,0);

		addOnView = (*AddOnView)(frame);		// Start the Constructor of the ADD-ON View
		AddChild( addOnView );					// Add it to the Window
		addOnView->GetPreferredSize(&w, &h);	// And then resize it to the correct width and height
		ResizeTo(w, h);							// and we set our Window to the correct size!

				// lets move the Window in the middle of our PalmBeach-Window!
		MoveTo(r.left + ((r.Width() - w) / 2), r.top + ((r.Height() - h) / 2));
		
	} else AddOnView = NULL;
}

//============================================================================
// Returns true, if there is a ConfigView Symbol!
// 

bool AddOnConfigWindow::HasConfigView( void ) {
	return ( AddOnView == NULL ? false : true );
}