//=====================================================================
// AddOnListItem.h
// © Michael Pieper 21. Mar. 1999
//=====================================================================
//
//  This headerfile defines the class "AddOnListItem", which is used to
//  manage the PalmBeach ADD-Ons-List
//
//=====================================================================

#ifndef ADDONLISTITEM_H
#define ADDONLISTITEM_H

#include <InterfaceKit.h>


//=====================================================================
//  AddOnListItem class

class AddOnListItem : public BListItem
{
public:
	//constructor and destructor
					AddOnListItem( BEntry *entry );
					~AddOnListItem( void );

	virtual void	DrawItem(BView *owner, BRect frame, bool complete = false);
	virtual void	Update(BView *owner, const BFont *font);

	image_id		GetImageId( void );
	thread_id		RunThread( char *whichone );
	bool			StopThread( void );
	
	void			ShowConfigWindow( BRect frame );
	char			*Text( void );

private:		// things, we need only intern!
	char			*filename;					// The Filename of the AddOn
	BBitmap			*smallicon;					// The small Icon of the AddOn
	image_id		img_id;						// The Image_id of a loaded AddOn
	thread_id		thr_id;						// The Thread_id, of the running thread
	
	long			FindAllAddons( void );		// Reads all ADD-ONS	
};


//=====================================================================

#endif
