//============================================================================
// AddOnView.cpp
// © Michael Pieper 16. Feb. 1999
//============================================================================
//
//	This class manages the add-ons. 
//  Set the Server-addon, which should be loaded after connecting the PSION
//  Set the Debug-output for each add-on
//
//============================================================================

#include "AddOnView.h"
#include "AddOnListItem.h"
#include "PsionNCP.h"
#include <InterfaceKit.h>		// We want to do some drawing :-)
#include <StorageKit.h>

#include <stdio.h>
#include <stdlib.h>				// needed for Malloc
#include <string.h>

//============================================================================
// Constructor for the View.
// We have to construct our design!
//

AddOnView::AddOnView( BRect rect, const char *name )
		: BView( rect, name, B_FOLLOW_ALL_SIDES, B_WILL_DRAW ) 
		
{
	SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));

	BRect r = Bounds();
	r.InsetBy(5,5);											// we want a border!
	r.right = be_plain_font->StringWidth("WWWWWWWW.WWW");	// calculate the maximum width
		
	addon_list = new BListView(r, "Add-Ons", B_SINGLE_SELECTION_LIST, B_FOLLOW_ALL_SIDES); 	// add the ListView

	addon_list->AddItem(new AddOnListItem(NULL)); 			// add always the NCP, because it is built in
	FindAllAddons();										// Find al add-ons and insert it in the view

	AddChild(new BScrollView("scroll_addons", addon_list, 
					B_FOLLOW_LEFT | B_FOLLOW_TOP_BOTTOM, B_WILL_DRAW, false, true));
	
	r.left = r.right + 10 + B_V_SCROLL_BAR_WIDTH;
	r.right = Bounds().right - 5;
	r.bottom += 2;
	
	BBox *setting = new BBox(r, "Settings", B_FOLLOW_ALL_SIDES );	// Setup the Information-Block
	setting->SetFont(be_plain_font);
	setting->SetLabel("Add-Ons Setting");
	AddChild(setting);
	
	font_height height;												// Calculate the height of one line!
	GetFontHeight(&height);
	float h = height.ascent + height.descent + height.leading + 1;	// add all Font-infos and 1 point
	
	r.left = 5;
	r.right = be_plain_font->StringWidth("WVersion:");
	r.top = h + 5;
	r.bottom = r.top + h;

	BStringView *bsv;
	
	setting->AddChild(bsv = new BStringView(r, "AOV-N", "Name:"));		// Setup Informationlines
	bsv->SetAlignment(B_ALIGN_RIGHT);
	r.OffsetBy(0, h+5);
	setting->AddChild(bsv = new BStringView(r, "AOV-V", "Version:"));
	bsv->SetAlignment(B_ALIGN_RIGHT);
	r.OffsetBy(0, h+5);
	setting->AddChild(bsv = new BStringView(r, "AOV-T", "Type:"));
	bsv->SetAlignment(B_ALIGN_RIGHT);
	r.OffsetBy(0, h+5);
	setting->AddChild(bsv = new BStringView(r, "AOV-I", "Info:"));
	bsv->SetAlignment(B_ALIGN_RIGHT);

	r.left = r.right;
	r.right = setting->Bounds().right - 5;
	r.top = h + 5;
	r.bottom = r.top + h;

	// Now we have to Add all the fields, for the add-on information
	setting->AddChild(addon_name = new BStringView(r, "AOVI-N", "", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP));
	r.OffsetBy(0, h+5);
	setting->AddChild(addon_version = new BStringView(r, "AOVI-V", "", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP));
	r.OffsetBy(0, h+5);
	setting->AddChild(addon_type = new BStringView(r, "AOVI-T", "", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP));
	r.OffsetBy(0, h+5);
	setting->AddChild(addon_info[0] = new BStringView(r, "AOVI-I1", "", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP));
	r.OffsetBy(0, h+5);
	setting->AddChild(addon_info[1] = new BStringView(r, "AOVI-I2", "", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP));
	r.OffsetBy(0, h+5);
	setting->AddChild(addon_info[2] = new BStringView(r, "AOVI-I3", "", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP));
	r.OffsetBy(0, h+5);

	r = setting->Bounds();
	
	modifyButton = new BButton(r, NULL, "Modify addon settings", new BMessage(MSG_ADDONS_MODIFY), B_FOLLOW_LEFT_RIGHT | B_FOLLOW_BOTTOM);
	setting->AddChild(modifyButton);
	modifyButton->ResizeToPreferred();
	
	modifyButton->MoveTo((r.Width()-modifyButton->Frame().Width())/2, r.bottom-(modifyButton->Frame().Height()+5));
	modifyButton->SetEnabled(false);
}

//============================================================================
// The function AttachedToWindow sets the message for all elements in the view
// because we must be attached to select the View as the target!
//

void AddOnView::AttachedToWindow( void ) {

	addon_list->SetSelectionMessage(new BMessage(MSG_ADDONS_SELECT));
	addon_list->SetInvocationMessage(new BMessage(MSG_ADDONS_INVOKE));
	addon_list->SetTarget(this);
	modifyButton->SetTarget(this);
}

//===============================================================================
// We are interested in receiving some messages from this view. So we want to do 
// something with them

void AddOnView::MessageReceived( BMessage *msg ) {
	
	int32			addon_index;				// Variable for the ListItem Index
	image_id		img_id;
	entry_ref		ref;
	char			*string;
	
	switch(msg->what) {
		case MSG_ADDONS_MODIFY:							// user clicked on the MODIFY-Button
			addon_index = addon_list->CurrentSelection();
			if (addon_index >= 0) {
				((AddOnListItem *)(addon_list->ItemAt(addon_index)))->ShowConfigWindow( Window()->Frame() );
			}
			break;
		case MSG_ADDONS_INVOKE:
			msg->FindInt32("index", &addon_index);
			if (addon_index >= 0) {
				((AddOnListItem *)(addon_list->ItemAt(addon_index)))->ShowConfigWindow( Window()->Frame() );
			}
			break;
		case MSG_ADDONS_SELECT:
			msg->FindInt32("index", &addon_index);

			if (addon_index >= 0) {
				addon_name->SetText( ((AddOnListItem *) (addon_list->ItemAt(addon_index)))->Text() );
				if (strcmp(addon_name->Text(), "NCP") == 0) {	// NCP is builtin, so we have to report the Values
					addon_version->SetText(NCP_ADDON_VERSION);
					addon_type->SetText(NCP_ADDON_TYPE);
					addon_info[0]->SetText(NCP_ADDON_INFO1);
					addon_info[1]->SetText(NCP_ADDON_INFO2);
					addon_info[2]->SetText(NCP_ADDON_INFO3);
					modifyButton->SetEnabled(false);
				} else {										// When we got no informations, then set all empty
					img_id = ((AddOnListItem *) (addon_list->ItemAt(addon_index)))->GetImageId();
   					if (get_image_symbol(img_id, "InfoVersion", B_SYMBOL_TYPE_DATA, (void **)&string) == B_OK) { 
						addon_version->SetText(string);
					} else addon_version->SetText("");
   					if (get_image_symbol(img_id, "InfoLine1", B_SYMBOL_TYPE_DATA, (void **)&string) == B_OK) {
						addon_info[0]->SetText(string);
					} else addon_info[0]->SetText("");
   					if (get_image_symbol(img_id, "InfoLine2", B_SYMBOL_TYPE_DATA, (void **)&string) == B_OK) {
						addon_info[1]->SetText(string);
					} else addon_info[1]->SetText("");
   					if (get_image_symbol(img_id, "InfoLine3", B_SYMBOL_TYPE_DATA, (void **)&string) == B_OK) {
						addon_info[2]->SetText(string);
					} else addon_info[2]->SetText("");
   					if (get_image_symbol(img_id, "RunServer", B_SYMBOL_TYPE_TEXT, (void **)&string) == B_OK) {
						addon_type->SetText("Server");
					} else if (get_image_symbol(img_id, "RunClient", B_SYMBOL_TYPE_TEXT, (void **)&string) == B_OK) {
						addon_type->SetText("Client");
					} else addon_type->SetText("unknown");
   					if (get_image_symbol(img_id, "ConfigView", B_SYMBOL_TYPE_TEXT, (void **)&string) == B_OK) {
						modifyButton->SetEnabled(true);
					} else modifyButton->SetEnabled(false);
				}
			} else {
				addon_name->SetText("");					// All deselected, then delete the Text
				addon_version->SetText("");
				addon_type->SetText("");
				addon_info[0]->SetText("");
				addon_info[1]->SetText("");
				addon_info[2]->SetText("");
				modifyButton->SetEnabled(false);
			}
			break;
   		case B_SIMPLE_DATA:									// Simple Data seams that it is a drg&drop-Message with a filename
   		   			// Look for a ref in the message
   			if( msg->FindRef("refs", &ref) == B_OK ){
   				CopyAddon(&ref);							// Lets copy the file!
   			} else {
   				// Call inherited if we didn't handle the message
   				BView::MessageReceived(msg);
   			}
   			break;
   		default:
   			// Call inherited if we didn't handle the message
   			BView::MessageReceived(msg);
   			break;
    }
}

//===============================================================================
// We have to search alle the Files in the ADD-ONS-Folder. 
// 

long AddOnView::FindAllAddons(void) {

	app_info	apinfo;
	BEntry		ent;
	BPath		path;
	BDirectory	dir;
	BNode		node;
	BNodeInfo	ninf;
	node_ref	nref; 
	
	be_app->GetAppInfo(&apinfo);			// we are interested in our Startingdirectory
	ent.SetTo(&apinfo.ref);					// but we can get only the entry_ref of PalmBeach
	ent.GetParent(&dir);					// lets ask about the Directory of PalmBeach
	path.SetTo(&dir, "add-ons");			// and then look into the add-ons Directory
	dir.SetTo(path.Path());					// lats make a directory from the Path
	
	if (dir.InitCheck() == B_OK) {
		while (dir.GetNextEntry(&ent) == B_OK) {
			addon_list->AddItem(new AddOnListItem(&ent)); 			// add all add-on's I found 
		}
		dir.GetNodeRef(&nref); 
   }

	return 0;
}

//===============================================================================
// The Nodemonitor told us, that there is any change.
// if newFileName isn't NULL, then there is a new file added to the folder!
// we always check, if all the entries are valid!
//
long AddOnView::UpdateAddons( char *newFileName ) {

	app_info		apinfo;
	BEntry			ent;
	BDirectory		dir;
	AddOnListItem	*aoli;
	int32			l;
	
	be_app->GetAppInfo(&apinfo);		// we are interested in our Startingdirectory
	ent.SetTo(&apinfo.ref);				// but we can get only the entry_ref of PalmBeach
	ent.GetParent(&dir);				// lets ask about the Directory of PalmBeach
	dir.SetTo(&dir, "add-ons");			// and then look into the add-ons Directory

	for (l = addon_list->CountItems() - 1; l >= 0; l--) {
		aoli = (AddOnListItem *)addon_list->ItemAt(l);	// get the one Item
		if (aoli != NULL) {
			if (strcmp(aoli->Text(), "NCP") == 0) continue;	// The NCP is a builtin process. there is no coresponding file!
			ent.SetTo(&dir, aoli->Text());					// set the Entry to the add-on
			if (! ent.Exists() ) { 
				addon_list->RemoveItem(aoli);	// it dosn't exist any more!
			}
		}
	}	

	if (newFileName != NULL) {
		ent.SetTo(&dir, newFileName, true);					// we need a entry for this.
		if ( ent.InitCheck() == B_OK && ent.Exists() ) {	// check, if the file is moved to our folder!
			addon_list->AddItem(new AddOnListItem(&ent)); 	// add the new add-on
   		}
   	}

	return 0;
}

//===============================================================================
// This process searches the correct Add-On Server and starts it as a thread.
// The thread_id is returned

thread_id AddOnView::StartAddOnServerThread( char *server_name ) {

	AddOnListItem	*aoli;
	int32			count;
	
	count = addon_list->CountItems();		// ask how much Items ar available
	for (count--; count >= 0; count--) {	// Walk through the list
		aoli = (AddOnListItem *) addon_list->ItemAt(count);
		if (strcmp( aoli->Text(), server_name) == 0) {	// if we found the correct file.
			return ( aoli->RunThread("RunServer") );			// lets run th add-on as a own thread!
			break;
		}
	}
	return (B_ERROR);		// We havn't found any correct add-on
}

//===============================================================================
// This process searches all Add-on Clients and starts every client!

bool AddOnView::StartAllClients( void ) {

	AddOnListItem	*aoli;
	int32			count;
	
	count = addon_list->CountItems();		// ask how much Items ar available
	for (count--; count >= 0; count--) {	// Walk through the list
		aoli = (AddOnListItem *) addon_list->ItemAt(count);
		aoli->RunThread("RunClient");			// lets run the add-on as a own thread!
	}
	return (true);		// at the moment we report no error
}

//===============================================================================
// This process searches all Add-on Clients and stops every running client!

bool AddOnView::StopAllClients( void ) {

	AddOnListItem	*aoli;
	int32			count;
	
	count = addon_list->CountItems();		// ask how much Items ar available
	for (count--; count >= 0; count--) {	// Walk through the list
		aoli = (AddOnListItem *) addon_list->ItemAt(count);
		aoli->StopThread();					// lets stop the add-on thread!
	}
	return (true);		// at the moment we report no error
}

//===============================================================================
// We need a function, which is able to copy a add-on into the correct path!

status_t AddOnView::CopyAddon(entry_ref *entry) {

	BFile			src, dest;
	app_info		apinfo;
	BEntry			ent;
	BDirectory		dir;
	char			buffer[1024], *b;
	char			attr[B_ATTR_NAME_LENGTH]; 
	size_t			len;
	attr_info		ati;
	
	be_app->GetAppInfo(&apinfo);		// we are interested in our Startingdirectory
	ent.SetTo(&apinfo.ref);				// but we can get only the entry_ref of PalmBeach
	ent.GetParent(&dir);				// lets ask about the Directory of PalmBeach
	dir.SetTo(&dir, "add-ons");			// and then look into the add-ons Directory
	
	src.SetTo(entry, B_READ_ONLY);
	dest.SetTo(&dir, entry->name, B_READ_WRITE | B_FILE_EXISTS | B_CREATE_FILE );
	
	if (src.InitCheck() == B_OK && dest.InitCheck() == B_OK) {
	
		do len = src.Read(buffer, 1024);					// lets copy a file 1. read
		while (dest.Write(buffer, len) == len && len > 0);	// 2. write the file. We have to stop, when a error occured or all bytes are transfered

		src.RewindAttrs();								// Lets begin with the first Attribute
		while (src.GetNextAttrName(attr) == B_OK) {		// Get the Name of the first one
			src.GetAttrInfo(attr, &ati);				// Get the Info how long it is n which type it should be

			b = (char *)((ati.size > 0) ? malloc(ati.size) : NULL);	// we have to reserve some space for the attribute
			if (len > 0 && b == NULL) return (B_NO_INIT );			// a error occured!
			
			src.ReadAttr(attr, ati.type, 0, b, ati.size);		// Copy the attributes
			dest.WriteAttr(attr, ati.type, 0, b, ati.size);

			if (b != NULL) free(b);						// And release the memory
		}
		return( B_OK );
	} else return ( B_NO_INIT  );
}

