//=====================================================================
// AddOnView.h
// © Michael Pieper 16. Feb. 1999
//=====================================================================
//
//  This headerfile defines the class "AddOnView", which is used to
//  manage the PalmBeach ADD-Ons
//
//=====================================================================

#ifndef ADDONVIEW_H
#define ADDONVIEW_H

#include <InterfaceKit.h>
#include <KernelKit.h>			// we need this for thread-functions

//=====================================================================
// We need some #defines for the Builtin NCP-Add-ON

#define NCP_ADDON_VERSION	"0.25  " B_UTF8_COPYRIGHT "1999 by Michael Pieper"
#define NCP_ADDON_TYPE      "Server (builtin)"
#define NCP_ADDON_INFO1     "NCP = Network Control Process"
#define NCP_ADDON_INFO2     "distributs a message to"
#define NCP_ADDON_INFO3     "one of 8 possible channels."

//=====================================================================
// We need some BMessages for the communication in the View!

#define MSG_ADDONS_SELECT	'aose'
#define MSG_ADDONS_INVOKE	'aoin'
#define MSG_ADDONS_NEWONE	'aonw'
#define MSG_ADDONS_MODIFY	'aomf'

//=====================================================================
//  AddOnView class
class AddOnView : public BView
{
public:
	//constructor and destructor
					AddOnView( BRect rect, const char *name );
					
	void			AttachedToWindow( void );
	void			MessageReceived( BMessage *msg );
	thread_id		StartAddOnServerThread( char *server_name );	// Starts the named Server as a own thread
	bool			StartAllClients( void );						// Starts all known Clients
	bool			StopAllClients( void );							// Stops all known Threads

	long			UpdateAddons( char *newFileName );				// Update the AddOn-View

private:		// things, we need only intern!
	BListView		*addon_list;		// The ListView containing all add-ons
	BStringView		*addon_name;		// The Addonname for displaying
	BStringView		*addon_version;		// The Addonversion for displaying
	BStringView		*addon_type;		// The Addontype (Server or Client) for displaying
	BStringView		*addon_info[3];		// 3 Informationlines
	BButton			*modifyButton;		// A button to change the Settings
	
	long			FindAllAddons( void );		// Reads all ADD-ONS	
	status_t		CopyAddon(entry_ref *entry);	// copy's the file entry into the add-onPath
};


//=====================================================================

#endif
