//=====================================================================
// SettingsView.h
// © Michael Pieper 27. Mar. 1999
//=====================================================================
//
//  This headerfile defines the class "SettingsView", which is used to
//  manage the PalmBeach Preferences
//
//=====================================================================

#ifndef SETTINGSVIEW_H
#define SETTINGSVIEW_H

#include <InterfaceKit.h>

//=====================================================================
// We need some BMessages for the communication in the View!

#define MSG_SAVE_PREF		'sesv'
#define MSG_MOUNTPOINT		'semt'
#define MSG_B_9600_BPS		'se09'
#define MSG_B_19200_BPS		'se19'
#define MSG_B_38400_BPS 	'se38'
#define MSG_B_57600_BPS 	'se57'
#define MSG_B_115200_BPS 	'se15'
#define MSG_B_230400_BPS	'se30'
#define MSG_PORT			'sept'
#define MSG_MNTPT_SEARCH	'sems'
#define MSG_FILEPANEL		'sefp' 

//=====================================================================
// Lets define the Settingsfilenames:

#define SETTING_FILE	"PalmBeach"
#define SETTING_BACKUP	"PalmBeach.bak"

//=====================================================================
//  SettingsView class
class SettingsView : public BView
{
public:
	//constructor and destructor
					SettingsView( BRect rect, const char *name, BSerialPort *PsiPort);
	void			AttachedToWindow( void );
	void			MessageReceived( BMessage *msg );
	void			SavePreferences( void );
	void			LoadPreferences( void );
	
private:

	BSerialPort		*PsiPort;			// We must know, which port we are working on
	BMenuField		*serialDevice;		// here we can select the Device
	BMenuField		*serialSpeed;		// this is the Speed of the SerialDevice
	BButton			*saveButton;		// we need it for the BMessage-Target
};

//=====================================================================

#endif
