/*-------------------------------------------------------------------------
!  Diese Datei sorgt dafür, daß der Level 1 des PLP (PSION Link Protokolls)
!  korrekt geschrieben wird! 
!  Nach dem schreiben wird auf eine Bestätigung gewartet.
!  Zur Kommunikation werden Ports verwendet!
+-----------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>	// for mount, and unmount
#include <string.h>

#include "messages.h"
#include "thread.h"
#include "WriteSerial.h"
#include "ReadSerial.h"
#include "PsiNCPWindow.h"
#include "PsionNCP.h"

// Die nachfolgenden zwei Funktionen dienen lediglich zur Berechnung der CRC-Summe
// Diese Funktionen werden in ReadSerial.c und WriteSerial.c benötigt!
//
// Der polywert ist: x^16+x^12+x^5+x^0.
//   =   0001 0000 0010 0001
#define P 0x1021
unsigned short	crctab[256];	// CRC-Lookuptable

// Diese Funktion berechnet eine CRC-Lookuptable mit 256 Werten
// Sie ist einmal vor dem Berechnen der ersten CRC-Summe aufzurufen und kann dann
// solange wie das Programm läuft benutzt werden.
void make_crctable(void) {
	register unsigned int b, v;
	register int i;
	for (b = 0; b < 256; b++) {
		v = b << 8;
		for (i = 8; i--; ) v = v & 0x8000 ? (v << 1) ^ P : v << 1;
		crctab[b] = v & 0xFFFF;
	}
}

// Eine CRC-Summe wird berechnet, indem man die folgende Funktion aufruft.
// der Wert crc ist dabei am Anfang auf 0 zu setzen.
// Will man mehrere Werte mit mehreren Aufrufen berechnen, so ist crc immer mit
// dem letzen Rückgabewert zu besetzen.
unsigned short Calccrc(register unsigned short crc, register unsigned char *cp, register int len)
{
	while (len--) crc = (crc << 8) ^ crctab[(crc >> 8 ^ *cp++) & 0xff];
	return (crc);
}

// Die folgende Routine schreibt die Bytes direkt in die geöffneten Schnittstelle

int32 PsiWrite(void *psiptr) {
	BSerialPort *psion = (BSerialPort *)psiptr;

	thread_id		thr_id_read;
	port_id			pid_o, pid_c;
	unsigned char	command = 0x31;
	unsigned char	dummy[5];
	unsigned char	*buffer, *send_pointer;
	int32			message;
	ssize_t 		p_len, send_len;
	NUCB			*n;
	int				i, fr_no;
	
	make_crctable();			// CRC-Tabelle berechnen

	pid_o =  create_port(5 /*B_MAX_PORT_COUNT*/, WRITE_PORT);// Über diesen Port kommen die zu versendenden Nachrichten
	if (pid_o < B_NO_ERROR) {
		printf("internes Portöffnen fehlgeschlagen\n");
		exit_thread(-1);
	}
	pid_c =  create_port(5 /*B_MAX_PORT_COUNT*/, CTRL_PORT);// Über diesen Port kommen die Bestätigungen der versandten Nachrichten
	if (pid_c < B_NO_ERROR) {
		printf("internes Portöffnen fehlgeschlagen\n");
		delete_port(pid_o);
		exit_thread(-1);
	}

	thr_id_read = spawn_thread(PsiRead, "ReadPsion", B_NORMAL_PRIORITY, psion);
	if (thr_id_read < B_NO_ERROR) {
		printf("Fehler beim Starten!\n");
		switch (thr_id_read) {
			case B_NO_MORE_THREADS: printf("Zuviele Threads\n"); break;
			case B_NO_MEMORY: printf("Zuwenig Speicher\n"); break;
			default: printf("Unbekannter Fehler: %ld\n", thr_id_read); break;
		}
		exit_thread(-1);
	} else {
		if (resume_thread(thr_id_read) < B_NO_ERROR) {		// Thread starten!
			printf("Fehler beim starten des Threads\n");
			exit_thread(-1);
		}
	}

	while ((p_len = port_buffer_size(pid_o)) >= B_NO_ERROR) {	// auf Nachrichten warten!

		buffer = (unsigned char *)malloc(p_len);	// Speicher für die Nachricht reservieren.
		if (buffer != NULL) {
			if (read_port(pid_o, &message, buffer, p_len) < B_NO_ERROR) break;

			i = (message & CHAN_MASK) >> MOVE_CHAN;
			if ((message & CMD_MASK) == PSION_SSERV) { // Hier soll auf dem PSION ein Server gestartet werden!
				printf("Starten des Servers: >%s< >%s<\n", buffer, &buffer[strlen((char *)buffer)+1]);

				n = NULL;
				for (i = NC_MAX_USER-1; i >= 0; i--) {	// Wir fangen oben an, damit wir den ersten freien erhalten :-)
					if (!(nucb[i].flags & NC_LINK_ACTIVE)) n = &nucb[i];	// Freie Links merken!
				}
				n->flags = NC_LINK_ACTIVE;	// Link als aktiv vermerken!
				n->name[0] = '\0';
				strncpy(n->name, (char *)buffer, sizeof(n->name));
				n->pid = find_port((char *)&buffer[strlen((char *)buffer)+1]);
	printf("Portid=%ld vom Port:>%s<\n", n->pid, (char *)&buffer[strlen((char *)buffer)+1]);			
				send_pointer = (unsigned char *)malloc(50);
				send_pointer[0] = 0;	// zum NCP senden!
				send_pointer[1] = n->local_id;
				send_pointer[2] = NCON_MSG_CONNECT_TO_SERVER;
				strcpy((char *)&send_pointer[3], n->name);
				while (true) {
					SendMsg(psion, command, 1, NULL, send_pointer, strlen((char *)&send_pointer[3])+4);
					if (read_port_etc(pid_c, &message, dummy, 1, B_TIMEOUT, 5000000) == 1) { // 5 Sekunden auf Bestätigung warten (Es wird genau 1 Byte erwartet!)
						if ((command & 0x07) == *dummy) { 
//	printf("Acknowledge in Ordnung!\n");
							command = (++command & 0x37);	// 0011 0111  Nur diese Bits halten!
							break;	// Beendet die while(true)-Schleife!
						} else printf("ACHTUNG! Fehler im ACK!\n");
					}
				}



				free(send_pointer);
				
			} else if (i >= 0 && i < NC_MAX_USER && nucb[i].ch_crc == (message & ID_MASK)) {
				n = &nucb[i];
			
				switch (message & CMD_MASK) {
					case PSION_CMD: 
						send_pointer = buffer;
						for (fr_no = (p_len / NC_MAX_MSG_LEN) + 1; fr_no > 0; fr_no--) {
							send_len = p_len > (NC_MAX_MSG_LEN) ? NC_MAX_MSG_LEN : p_len;
							while (true) {
								SendMsg(psion, command, fr_no, n, send_pointer, send_len);
								if (read_port_etc(pid_c, &message, dummy, 1, B_TIMEOUT, 5000000) == 1) { // 5 Sekunden auf Bestätigung warten (Es wird genau 1 Byte erwartet!)
									if ((command & 0x07) == *dummy) { 
//	printf("Acknowledge in Ordnung!\n");
										command = (++command & 0x37);	// 0011 0111  Nur diese Bits halten!
										break;	// Beendet die while(true)-Schleife!
									} else printf("ACHTUNG! Fehler im ACK!\n");
								}
							}
							send_pointer += send_len;
							p_len -= send_len;
						}
						break;
					case PSION_MSG:	
						SendMsg(psion, *buffer, 1, NULL, NULL, 0);
						if (*buffer == 0x00) command = 0x31;	// Rücksetzen der sequenzid erhalten.
						break;
					case PSION_SACK:
						SendMsg(psion, *buffer, 1, NULL, NULL, 0);	// Acknowledge schicken!
						break;
					case PSION_DISC:
						myWindow->addOnView->StopAllClients();	// We have to close all Connections

						dummy[0] = 0x10;
						SendMsg(psion, dummy[0], 1, NULL, NULL, 0);// Disconnect schicken!
						discon_channel ( nucb );				// NCP auch noch beenden!
						kill_thread(thr_id_read);				// Lese-Thread beenden
						psion->Close();							// Seriellen Port schließen
						delete_port(pid_o);						// Die Ports werden auch nicht mehr benötigt
						delete_port(pid_c);

						exit_thread(0);							// Damit bleibt für uns auch nix mehr zu tun!
						break;
				}
			} else printf("nucb nicht gefunden! %lx\n", message);
			free(buffer);
		}
	}

	delete_port(pid_o);
	delete_port(pid_c);

	exit_thread(p_len);	// Port wurde gelöscht?
	return 0;
}


// die folgende Funktion schickt eine Nachricht über die Schnittstelle
// Kümmert sich um die ESC-Sequenzen und die CRC-Berechnung
// Framenr ist die Framenumerierung, die vor die Framedaten gesetzt werden!

void SendMsg(BSerialPort *psion, unsigned char seqid, unsigned char frame_nr, NUCB *nucb, unsigned char *buffer, size_t len) {
								
	unsigned char	head[3]={ 0x16, 0x10, 0x02 };			// Header
	unsigned char	foot[4]={ 0x10, 0x03, 0x00, 0x00 };		// Footer + CRC-Summe
	unsigned char	id[3]={ 0x00, 0x00 };					// Kanalid's + Framenr.
	unsigned short	crc;
	unsigned char	*p, *start;
	
	crc = Calccrc(0, &seqid, 1);							// Zur CRC gehört auch die Sequenzid
	if (nucb != NULL && nucb->remote_id != 0) {				// Die Kanalids werden nur verwendet, wenn's keine NCP verbindung oder LowLevel Protokoll ist
		id[0] = nucb->remote_id;
		id[1] = nucb->local_id;
		id[2] = frame_nr;
		crc = Calccrc(crc, id, 3);							// Außerdem die Kanalid's
	}
	if (len > 0) crc = Calccrc(crc, buffer, len);			// und die Daten an sich.
	
	foot[2] = crc >> 8;										// CRC-Summe setzen
	foot[3] = crc & 0xff;
	
	psion->Write(head, 3);					// Header können wir bereits schicken
	psion->Write(&seqid, 1);				// die Seuqenzid ebenfalls

//	printf("PC->PSION: 16 10 02 %02x ", seqid);

	if (nucb != NULL && nucb->remote_id != 0) {
		psion->Write(id, 3);	// sowie die Kanalid's und die Framenr.
//		printf("%02x %02x %02x ", id[0], id[1], id[2]);
	}
	
//	for (int i = 0; i < len; printf("%02x ", buffer[i++])) ;
//	printf("10 03 %02x %02x\n", foot[2], foot[3]);
	
	if (len > 0) {
		p = start = buffer;
		while ((p = (unsigned char *)memchr(start, 0x10, len - (start-buffer))) != NULL) {
			psion->Write(start, (p-start)+1);
			psion->Write(p, 1);
			start = &p[1];
		}
		psion->Write(start, len - (start-buffer));	// Rest schicken
	}
	psion->Write(foot, 4);

}
