//=====================================================================
// LinkServer.cpp
// © Michael Pieper 14. Feb. 1999
//=====================================================================
//
//  This class is used to manage the LINK-Connection from the PSION
//
//=====================================================================
#include "../DebugMsg/debugMsg.h"

#include <stdio.h>
#include <stdlib.h>
#include "LinkServerAddOn.h"
#include "LinkServer.h"

#include "../messages.h"

//=====================================================================
// 

LinkServer::LinkServer( CONFIG_VAR *config ) {

	int32	message;
	int 	i;
	char	text[50];
	
	if (config->debug) dprint = new DebugMsg( config->debugFile, "LINK-Server");
	else dprint = new DebugMsg( NULL, NULL );

	pid_i = find_port("LINK");			// Through this port we receive all Messages from the serial Port
	pid_o = find_port("WritePsion");	// If we want to write something, we have to do this through this port

	if (pid_o < B_NO_ERROR || pid_i < B_NO_ERROR) exit_thread(pid_o);

	for (i = 0; i < 5; i++) {						// Lets try 5 times to catch a correct start
		read_port(pid_i, &message, NULL, 0);		// first we got our ChannelID (works like a Filediskriptor)
		if ((message & CMD_MASK) == PSION_START) {
			cid = message & CID_MASK;				// lets remember which ChannelID we have.
			break;									// leave the for-loop
		} else {
			sprintf(text, "Wrong message %lx", message);
			dprint->String(text);
		}
	}

	if (i < 5) RunServer();		// we got a right message, so lets start the Server!
	else dprint->String( "5 unidentified messages arrived! Can't start Server!" );

}

//=====================================================================
// 

void LinkServer::RunServer( void ) {
	unsigned char	*buffer;
	size_t			p_len;
	int32			message;
	
	dprint->String( "is running and waiting for messages!" );

	do {
		p_len = port_buffer_size(pid_i);	// how much bytes must we reserve for the incoming message?
		if (p_len < B_NO_ERROR) {
			dprint->String( "Port was deleted! Starting Servershutdown!" );
			break;		// When the port was deleted, then leave the "RunServer"
		}
		
		buffer = (unsigned char *)malloc(p_len);
		if (buffer != NULL) {
			read_port(pid_i, &message, buffer, p_len);

			dprint->Buffer( buffer, p_len, "unknown message arrived!" );
			
			free(buffer);
		}
	} while (true);
}


