//=====================================================================
// rfsvclient.h
// © Michael Pieper 2. Apr. 1999
//=====================================================================
//
//  This headerfile defines the class "RfsvServer", which is used to
//  manage the Fielsystemaddon
//
//=====================================================================

#ifndef RFSVCLIENT_H
#define RFSVCLIENT_H

#include "debugMsg.h"
#include "psionfs.h"			// MNT_INFO is declared here
#include "RfsvClientAddOn.h"
#include <SupportKit.h>			// needed for uint16 definition
#include <KernelKit.h>

//=====================================================================
// We have to define some global variables

#define READ_PORT  "PsionFS-Read"	// We define this name as a read-Portname
#define START_RFSV_SERVER "SYS$RFSV.*\0" READ_PORT


//=====================================================================
//  RfsvClient class
class RfsvClient
{
public:
	//constructor and destructor
					RfsvClient( CONFIG_VAR *conf );
	void			StartMount( void );
	void			WaitForShutdown( void );	
protected:

	
	// global variables need to communicate
	CONFIG_VAR		*config;		// a pointer to all configuration Variables
	MNT_INFO		*mount_info;	// a pointer to all mounted devices
	uint16			cid;			// Channelid to talk to the NCP
	port_id			pid_o, pid_i;	// Portids for the message handling
	DebugMsg		*dprint;		// Class for Debug-Messages
};

void WordToBytes(unsigned int i, unsigned char *p);
unsigned int BytesToWord(const unsigned char *c);

//****************************************

#endif
