/*============================================================================
/ attr.h
/ © Michael Pieper 30. Oct. 1999
/============================================================================
/
/	This header-File includes all "Attribute"-Functions for the PSION-FileSystem
/
/============================================================================*/

#ifndef PSIONFS_ATTR_H
#define PSIONFS_ATTR_H

#define BEOS_MIME_TYPE	'MIMS'
#define BEOS_MIME_NAME	"BEOS:TYPE"
#define LARGE_ICON_TYPE	'ICON'
#define LARGE_ICON_NAME	"BEOS:L:STD_ICON"
#define SMALL_ICON_TYPE	'MICN'
#define SMALL_ICON_NAME	"BEOS:M:STD_ICON"


#define PSION_VOLUME	"application/x-vnd.mp.psion-volume"

typedef struct psion_attr {		/* We need some info's for the psion-attributes */
	struct psion_attr	*next;	/* Pointer to the next attribute. If NULL, then there is no more attribute */
	char				*name;	/* Pointer to the name of the Attribure e.g. BEOS:TYPE */
	struct attr_info	attri;	/* An Attribute_Info-field. contains a uint32 type, off_t size */
	char				*data;	/* A Pointer to the Attribute-Data */
} psion_attr;

/*===========================================================================
/	This function finds the depending MIME-Types to any file!
/============================================================================*/

status_t set_mime_type(struct nspace *ns, struct vnode *node);

/*===========================================================================
/	All the attribute directory functions looks like the normal dir-functions
/============================================================================*/

int	psionfs_open_attrdir		(void *ns, void *node, void **cookie);
int	psionfs_close_attrdir		(void *ns, void *node, void *cookie);
int psionfs_free_attrdircookie	(void *ns, void *node, void *cookie);
int	psionfs_rewind_attrdir		(void *ns, void *node, void *cookie);
int	psionfs_read_attrdir		(void *ns, void *node, void *cookie, long *num, struct dirent *buf, size_t bufsize);

/*===========================================================================
/	Write(and create) and read the attribute itself
/============================================================================*/

int	psionfs_write_attr	(void *_ns, void *_node, const char *name, int type, const void *buf, 	size_t *len, off_t pos);
int	psionfs_read_attr	(void *_ns, void *_node, const char *name, int type, void *buf, 		size_t *len, off_t pos);

/*===========================================================================
/	remove and rename the attribute
/============================================================================*/

int	psionfs_remove_attr	(void *ns, void *node, const char *name);
int	psionfs_rename_attr	(void *ns, void *node, const char *oldname, const char *newname);

/*===========================================================================
/	return the type and the size!
/============================================================================*/

int	psionfs_stat_attr	(void *_vol, void *_node, const char *name, struct attr_info *buf);

/*===========================================================================
/	This function frees all attribute-structures depending to one vnode
/============================================================================*/

void free_all_attr	(psion_attr *at);

#endif

