// Psionfs.h

#ifndef PSIONFS_H
#define PSIONFS_H

#define MAX_BLOCK 511		// Definiert den maximalen Block für die Übertragung

#include "fsproto.h"

#include <fs_info.h>	
#include <SupportDefs.h>
 
#include "attr.h"

/* For each item on the disk (directory, file, etc), your filesystem should allocate a vnode struct and 
	pass it back to the kernel when fs_read_vnode is called. This struct is then passed back in to 
	your file system by functions that reference an item on the disk. You'll need to be able to
	create a vnode from a vnode id, either by hashing the id number or encoding the information needed
	to create the vnode in the vnode id itself. Vnode ids are assigned by your file system when the
	filesystem walk function is called. For this driver, the block number is encoded in the upper bits
	of the vnode id, and the offset within the block in the lower, allowing me to just read the info
	to fill in the vnode struct from the disk. When the kernel is done with a vnode, it will call 
	fs_write_vnode (somewhat of a misnomer) where you should deallocate the struct.
*/

typedef struct vnode
{
	/* Most drivers will probably want the first things defined here. */
	vnode_id	id; 
	vnode_id 	parID;			// parent vnode ID.
	char*		filename;		// Filename
	
	mode_t		mode;			// Filemodes
	size_t		size;			// Filesize
	time_t		modtime;		// Nur das Änderungsdatum vorhanden!
	
	struct vnode	*next;		// Verkettete VNODE im gleichen Verzeichnis
	struct vnode	*prev;		// Doppelt Verkettete Liste vorhergehender VNODE
	struct vnode	*child;		// erster VNODE im Unterverzeichnis.
	
	psion_attr 		*attr;		// A Pointer to the first Attribute!
	
	bool		read_all;		// Alle Files eingelesen
	bool		read_vnode;		// Speicherbereich durch read_vnode angefordert!
} vnode;

// These go with the flags member of the nspace struct.
/*enum
{
	ISO_ISHIDDEN = 0,
	ISO_ISDIR		= 2,
	ISO_ISASSOCFILE = 4,
	ISO_EXTATTR = 8,
	ISO_EXTPERM = 16,
	ISO_MOREDIRS = 128
};*/ 


// Arbitrarily - selected root vnode id
//#define PSION_ROOTNODE_ID 1

/* Structure used for directory "cookie". When you are asked
 	to open a directory, you are asked to create a cookie for it
 	and pass it back. The cookie should contain the information you
 	need to determine where you are at in reading the directory 
 	entries, incremented every time readdir is called, until finally
 	the end is reached, when readdir returns NULL. */
typedef struct dircookie
{
	int				fd;		// Filedeskriptor vom PSION für ein geöffnetes Laufwerk
	long			pos;	// Aktuell übergebene Strukturen an das Filesystem
	long			read;	// eingelesene Strukturen vom Filesystem
	unsigned char 	*buff;	// Buffer in die die Struktur eingelesen wurde
	vnode_id		node;	// Das ist der VNODE des directorys
} dircookie; 
 
/* You may also need to define a cookie for files, which again is 
	allocated every time a file is opened and freed when the free
	cookie function is called. For ISO, we didn't need one.
*/


/* This is the global volume nspace struct. When mount is called , this struct should
	be allocated. It is passed back into the functions so that you can get at any
	global information you need. You'll need to change this struct to suit your purposes.
*/

typedef struct nspace
{
	// Start of members other drivers will definitely want.
	nspace_id		id;				// ID passed in to fs_mount
	port_id			pid_write;		// Port ID um die benötigten Daten anzufordern
	port_id			pid_read;		// Port ID auf der die Antworten ankommen
	uint16			cid;			// Channel ID
	sem_id			port_sem;		// semaphore for writing and reading through the serial-port
	sem_id			dev_sem;		// unique semaphore for every mounted device
	char			device[128];	// Name of the Device
	vnode			*rootDir;		// Pointer auf Directory record for root directory
	
/*	//off_t			numBlocks;		// May need this, but it's part of ISO
	
	// End of members other drivers will definitely want.

	// All this stuff comes straight from ISO primary volume
	// descriptor structure.
	uint8			volDescType;		// Volume Descriptor type								byte1
	char			stdIDString[6];		// Standard ID, 1 extra for null						byte2-6
	uint8			volDescVersion;		// Volume Descriptor version							byte7
																			// 8th byte unused
	char			systemIDString[33];	// System ID, 1 extra for null							byte9-40
	char			volIDString[33];	// Volume ID, 1 extra for null							byte41-72
																			// bytes 73-80 unused
	uint32			volSpaceSize[2];	// #logical blocks, lsb and msb									byte81-88
																		// bytes 89-120 unused
	uint16			volSetSize[2];		// Assigned Volume Set Size of Vol						byte121-124
	uint16			volSeqNum[2];		// Ordinal number of volume in Set						byte125-128
	uint16			logicalBlkSize[2];	// Logical blocksize, usually 2048						byte129-132
	uint32			pathTblSize[2];		// Path table size										byte133-149
	uint16			lPathTblLoc[2];		// Loc (Logical block #) of "Type L" path table		byte141-144
	uint16			optLPathTblLoc[2];	// Loc (Logical block #) of optional Type L path tbl		byte145-148
	uint16			mPathTblLoc[2];		// Loc (Logical block #) of "Type M" path table		byte149-152
	uint16			optMPathTblLoc[2];		// Loc (Logical block #) of optional Type M path tbl	byte153-156
	char			volSetIDString[29];	// Name of multi-volume set where vol is member		byte191-318
	char			pubIDString[129];	// Name of publisher									byte319-446
	char			dataPreparer[129];	// Name of data preparer								byte447-574
	char			appIDString[129];	// Identifies data fomrat								byte575-702
	char			copyright[38];		// Copyright string										byte703-739
	char			abstractFName[38];	// Name of file in root that has abstract				byte740-776
	char			biblioFName[38];	// Name of file in root that has biblio				byte777-813

	ISOVolDate		createDate;			// Creation date										byte
	ISOVolDate		modDate;			// Modification date
	ISOVolDate		expireDate;			// Data expiration date
	ISOVolDate		effectiveDate;		// Data effective data
	
	uint8			fileStructVers;		// File structure version								byte882*/ 
} nspace; 

//=====================================================================
// We need a structure for the mount-Command

typedef struct mnti {
	bool			mounted;		// true or false for the info, if its mounted or not!
	port_id			pid_write;		// Portid for writing
	port_id			pid_read;		// Portid for reading
	uint16			cid;			// Channel ID
	sem_id			sem;			// Semaphore-ID to block, when writing through the serial port
	char			device[128];	// the device for mounting
	char			mnt_pt[128];	// the mountpoint
	char			debugFile[128];	// Name of the debugfile
	struct mnti 	*next;			// pointer to the next Mountinfo
} MNT_INFO;

#endif
