/*
 * App.cpp
 * Copyright Jonathan Booth, 1998
 *
 * This file is just here to call the application class.
 */

// Includes for it
#include "App.h"
#include <Alert.h>
#include <Window.h>

App::App() : BApplication("application/x-App")
{
	// Let's create the stuff that we need to look pretty.
	BWindow *Win = new BWindow(Default,"CPU Loads",B_TITLED_WINDOW,0);
	DataGatherer *Data = (DataGatherer *)new CPUGatherer(Maximum.x);
	BView *View = (BView *)new GraphView(Data);
	
	// add the view into the window
	if (Win->Lock()) {
		if (View) {
			Win->AddChild(View);
		}
		
		// Set the min and max window sizes
		Win->SetSizeLimits(Minimum.x,Maximum.x,
						   Minimum.y,Maximum.y);

		// Show the window to all
		Win->Show();

		// Undo the lock
		Win->Unlock();
	}
}

void App::AboutRequested() {
	BAlert *about = new BAlert("","ProcLoad2, Copyright December 17, 1998\n"
							   "Jonathan Booth (kamikaze@imsa.edu)\n\n"
							   "If you use ProcLoad2, please send an e-mail\n"
							   "to me. If you feel generous and wish to\n"
							   "make a contribution to the author\n"
							   "(#include PoorStarvingCollegeStudent.h)\n"
							   "send it to:\n\n"
							   "   Jonathan Booth\n"
							   "   29W131 Batavia Road\n"
							   "   Warrenville IL, 60555\n\n",
							   "Ok!");
	about->Go();
}

bool App::QuitRequested() { return true; }