/* AmTrackDataView.h
 * Copyright (c)1998-2000 by Eric Hackborn.
 * All rights reserved.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Eric Hackborn,
 * at <hackborn@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 *	- None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * Jan 23, 1999		hackborn
 * Changed GetEvents() so that it will flip the start and the end if the
 * rect passed in caused the end to be before the start.
 *
 * Jan 16, 1999		hackborn
 * Removed the CreateEvent() func.  That behaviour now appears shared
 * between the new NewEventStrategy() func and NewEvent().
 *
 * 11.11.98			hackborn
 * Mutated this file from the original SeqTrackDataView
 */


#ifndef AMPUBLIC_AMTRACKDATAVIEW_H
#define AMPUBLIC_AMTRACKDATAVIEW_H

#include <be/app/Message.h>
#include <be/app/MessageRunner.h>
#include "AmPublic/AmTimeConverter.h"
#include "AmPublic/AmEvents.h"
#include "AmPublic/AmTrackView.h"
class AmSignature;
class AmTool;
class AmToolTarget;

enum {
	/* The window containing the track data view understands this as
	 * a command to scroll the view.
	 */
	AM_SCROLL_MSG			= 'Ascr'
		// "x"				A float that scrolls on the x axis by the supplied amount
		// "pri y"			A float that scrolls the primary view on the y axis
		// "sec y"			A float that scrolls the secondary hrz manager view on the y axis
};

/*************************************************************************
 * AM-TRACK-DATA-VIEW
 * This class is the abstract base class for all views that present
 * editable MIDI data.
 *************************************************************************/
class AmTrackDataView : public AmTrackView
{
public:
	AmTrackDataView(AmSongRef songRef,
					BRect frame,
					const char *name,
					uint32 resizeMask,
					uint32 flags);
	virtual ~AmTrackDataView();

	virtual void AttachedToWindow();
	virtual void Draw(BRect clip);
	virtual	void GetPreferredSize(float *width, float *height);
	virtual	void KeyDown(const char *bytes, int32 numBytes);
	virtual	void KeyUp(const char *bytes, int32 numBytes);
	virtual void MessageReceived(BMessage* msg);
	virtual	void MouseDown(BPoint where);
	virtual	void MouseUp(BPoint where);
	virtual	void MouseMoved(	BPoint where,
								uint32 code,
								const BMessage *a_message);

protected:
	/* Subclasses are responsible for filling this with an
	 * appropriate target.
	 */
	AmToolTarget*	mTarget;
	/* If the user is operating (ie, one of the mouse buttons is depressed),
	 * then activeTool will be whatever tool they are using.
	 */
	AmTool*			mActiveTool;
	/* These values determine a saturation and baseline for drawing
	 * secondary events.  The saturation can be between 0 and 1.
	 * if it's 0, the secondary event shouldn't be drawn (and in
	 * fact, the DrawEvent() method won't even be called in this case).
	 * If it's 1, the secondary event should be drawn at its full
	 * colour.  Anything in between mixes the two extremes.
	 */
	float			mSecondarySaturation;
	rgb_color		mSecondaryBase;
	
	/*---------------------------------------------------------
	 * DRAWING
	 *---------------------------------------------------------*/
	virtual void DrawOn(BRect clip, BView* view);
	/* Subclasses are given the option to do any necessary processing
	 * before and after drawing any events.  These hook methods are empty.
	 */
	virtual void PreDrawEventsOn(BRect clip, BView* view, const AmTrack* track);
	virtual void PostDrawEventsOn(BRect clip, BView* view, const AmTrack* track);
	/* These are the various flags that might be supplied to the
	 * DrawEvent() method.
	 */
	enum EventFlags {
		ARPEVENT_PRIMARY		= 0x00000001,	// Draw the event as a primary event
		ARPEVENT_SECONDARY		= 0x00000002,	// Draw the event as a secondary event
		ARPEVENT_SELECTED		= 0x00000004,	// Draw the event selected
		ARPEVENT_HIGHLIGHTED	= 0x00000008	// Draw the event highlighted
	};
	/* The drawing methods happen as a result of Draw().  They
	 * all happen within one read transaction of AmTrack.
	 */
	virtual void	DrawSecondaryEvents(BRect clip, BView* view, const AmSong* song);
	virtual void	DrawPrimaryEvents(BRect clip, BView* view, const AmTrack* track);
	virtual void	DrawPhrase(	BRect clip,
								BView* view,
								AmPhraseEvent* event,
								AmTime start,
								AmTime end,
								int32 properties,
								AmSelectionsI* selections = 0);
	virtual void	DrawEvents(	BRect clip,
								BView* view,
								const AmPhrase& phrase,
								int32 properties,
								AmSelectionsI* selections = 0);
	/* Subclasses must implement to actually draw the event.
	 */
	virtual void	DrawEvent(BView* view, const AmEvent* event, int32 properties) = 0;

private:
	typedef AmTrackView		inherited;
	/* This delivers messages as long as the mouse button is held down,
	 * providing me the opportunity to scroll if the user moves out of bounds.
	 */
	BMessageRunner*			mScrollRunner;
	int32					mFlags;
	
	void		HandleScrollMsg(const BMessage* msg);

	/* The code for editing events programmatically.
	 */
	void		DeleteSelectedEvents();
	void		MoveEventsBy(AmTime timeDelta, int32 yDelta);
	void		TransformEventsBy(int32 xDelta, int32 yDelta);
	/* These are used to facilitate key presses.
	 */
	int32		mTransStep, mTransCount;
	AmTime		QuantizeTime() const;
	
	/* Ahhhh yeah, these are the commands that get invoked from key presses
	 * that cause events to get selected.  This is a mess right now, hacked in
	 * at the last minute.
	 */
	void		SelectRightEvent();
	status_t	NextRightEvent(	const AmTrack* track,
								AmEvent* event, AmPhraseEvent* container,
								AmEvent** eventAnswer, AmPhraseEvent** containerAnswer) const;
	/* Create a new selections object around the requested event.  The caller is responsible
	 * for actually calling SetSelections() on the target -- which CAN NOT be done while
	 * the song is locked.
	 */
	AmSelectionsI* SelectFirstEvent(const AmTrack* track);
	AmSelectionsI* SelectEvent(AmEvent* event, AmPhraseEvent* container);

	AmEvent*	FirstEvent(const AmTrack* track, AmPhraseEvent** answer) const;
};

#endif 
