/* ArpPrefsI.h
 * Copyright (c)2000 by Eric Hackborn.
 * All rights reserved.
 *
 * This file defines classes that provide global, application-wide
 * behaviour, along with functions for accessing instances of each
 * of these classes.  The application implementing this library needs
 * to implement the accessing functions.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Eric Hackborn,
 * at <hackborn@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * To Do
 * ~~~~~~~~~~
 *
 *	- Nothing!
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 *	- None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * 05.08.00		hackborn
 * Created this file.
 */

#ifndef ARPVIEWSPUBLIC_ARPPREFSI_H
#define ARPVIEWSPUBLIC_ARPPREFSI_H

#include <be/interface/Bitmap.h>
#include <be/interface/GraphicsDefs.h>

/***************************************************************************
 * ARP-PREFERENCES-I
 * A class defining the global preferences for the application.
 ***************************************************************************/
// Forward reference
class ArpPreferencesI;
// Accessing function
ArpPreferencesI& Prefs();

// Let application attach preferences object
void SetPrefs(ArpPreferencesI& prefs);

// The Size() preferences.  The convention is to postfix any size define
// by X for a width value, Y for a height, and XY for both.
#define EG_HANDLE_XY			(0)	// The distance from the center to the edge of an EG point handle
#define FONT_Y					(1) // The current font size
#define FULL_FONT_Y				(2) // The pixel height of the current font (including the ascent and descent)
#define MAINMENU_Y				(3) // The height that ExMenuBars should be
#define V_SCROLLBAR_X			(4) // The width of a vertical scrollbar
#define H_SCROLLBAR_Y			(5) // The height of a horizontal scrollbar
#define MENUFIELD_Y				(6) // The height that BMenuFields should be
#define MENUBAR_Y				(7) // The height that ExMenuBars should be
#define INT_CTRL_Y				(8) // The height of int controls.
#define BOX_CTRL_Y				(9) // The height of check box controls.

#define BORDER_X				(10) // The standard amount of horizontal space between a control and the
									 // edge of the window
#define BORDER_Y				(11) // Same as BORDER_X but vertical
#define SPACE_X					(12) // The standard amount of horizontal space between controls
#define SPACE_Y					(13) // Same as SPACE_X but vertical
#define BLANK_Y					(14) // The amount of space to use for blank lines
#define TAB_X					(15) // The amount of space to use for tabs

#define KNOB_X					(16) // The width of a plain, unadorned knob
#define KNOB_Y					(17) // The height of a plain, unadorned knob
#define KNOB_RING_X				(18) // The width of a knob adorned with the ring graphic
#define KNOB_RING_Y				(19) // The height of a knob adorned with the ring graphic
#define KNOB_RING_TIGHT_X		(20) // The width of a knob adorned with the ring graphic
#define KNOB_RING_TIGHT_Y		(21) // The height of a knob adorned with the ring graphic

#define CHECK_BOX_X				(22) // The width of a standard check box
#define CHECK_BOX_Y				(23) // The height of a standard check box
#define PROP_FIELD_X			(24) // The width of the property field
#define PROP_FIELD_Y			(25) // The height of the property field

// The Color() preferences.  The convention is to postfix any color define
// with C.
#define INT_CTRL_BG_C			(12) // The background color for int controls
#define INT_CTRL_BGF_C			(13) // The background color for int controls with focus
#define INT_CTRL_FG_C			(14) // The foreground color for int controls
#define INT_CTRL_FGF_C			(15) // The foreground color for int controls with focus

#define PERCENT_BAR_C			(16) // The color of the bar in the percent status view


class ArpPreferencesI
{
public:
	virtual ~ArpPreferencesI()	{ }
	
	virtual void	Initialize()		{ }
	
	/* Answer a pixel size for the supplied constant value.
	 */
	virtual float	Size(uint32 constant) const = 0;
	/* Answer an rgb_color for the supplied constant value.
	 */
	virtual rgb_color Color(uint32 constant) const = 0;
};

/***************************************************************************
 * ARP-IMAGE-MANAGER-I
 * A class that caches all the images in the application, and is therefore
 * responsible for loading and deleting them.  Client access is via name
 * strings.
 *
 * NOTE NOTE NOTE  This class has become a passthrough for the ResourceSet.
 * It's entirely possible this will go away and be replaced by a call
 * to that at some point.
 ***************************************************************************/
// Forward reference
class ArpImageManagerI;
// Accessing function
ArpImageManagerI& ImageManager();

// Let application attach image object
void SetImageManager(ArpImageManagerI& img);

class ArpImageManagerI
{
public:
	virtual ~ArpImageManagerI()	{ }
	
	// Arguments for the PictureAt() method flags arg.
	enum PictureFlags {
		ARP_USE_ALPHA	= 0x00000001
	};

	/* Answer the bitmap at the supplied name.  Name should be
	 * a resource name bound with the project.  Answer 0 if the
	 * bitmap doesn't exist.
	 */
	virtual const BBitmap* FindBitmap(const char *name) const = 0;
};

#endif
