/* ArpConsole.cpp
 */
#include "ArpConsole.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <experimental/ResourceSet.h>
#include "ArpKernel/ArpDebug.h"
#include "AmPublic/AmFilterConfigLayout.h"

ArpMOD();

static BResourceSet gResources;
static int32 gInitResources = 0;
BResourceSet& Resources()
{
	if (atomic_or(&gInitResources, 1) == 0) {
		gResources.AddResources((void*)Resources);
		atomic_or(&gInitResources, 2);
	} else {
		while ((gInitResources&2) == 0) snooze(20000);
	}
	return gResources;
}

/*****************************************************************************
 * ARP-CONSOLE-FILTER
 *****************************************************************************/
ArpConsoleFilter::ArpConsoleFilter(ArpConsoleFilterAddOn* addon,
								   AmFilterHolderI* holder,
								   const BMessage* config)
	: AmFilterI(addon),
	  mInstrument(NULL),
	  mAddOn(addon), mHolder(holder)
{
	//ArpRef<AmBank> bank = new AmBank(128);
	//mInstrument = new AmInstrument("Debug", bank);
	if (config) PutConfiguration(config);
}

ArpConsoleFilter::~ArpConsoleFilter()
{
}

AmEvent* ArpConsoleFilter::StartSection(AmTime firstTime, AmTime lastTime,
										const am_filter_params* params)
{
	printf("Filter %s: Start %Ld to %Ld\n", Label(), firstTime, lastTime);
		print_params(params);
	return NULL;
}

AmEvent* ArpConsoleFilter::FinishSection(AmTime firstTime, AmTime lastTime,
										 const am_filter_params* params)
{
	printf("Filter %s: Finish %Ld to %Ld\n", Label(), firstTime, lastTime);
		print_params(params);
	return NULL;
}

void ArpConsoleFilter::Stop()
{
	printf("Filter %s: Stop\n", Label());
}

AmEvent* ArpConsoleFilter::HandleEvent(AmEvent* event, const am_filter_params* params)
{
	if( !event ) printf("NULL event!\n");
	else {
		printf("Filter %s: ", Label());
		event->Print();
		print_params(params);
	}
	
	return event;
}

#define PREFIX "\t -> "

void ArpConsoleFilter::print_params(const am_filter_params* params) const
{
	if (!params) {
		printf(PREFIX "NO PARAMS.\n");
		return;
	}
	
	if (params->cur_tempo || params->cur_signature) {
		if (params && params->cur_tempo) {
			if (params->cur_tempo->NextEvent() != NULL) {
				printf(PREFIX "Tempos:\n"); params->cur_tempo->PrintChain(0, PREFIX);
			} else {
				printf(PREFIX "Tempo: "); params->cur_tempo->Print();
			}
		} else {
			printf(PREFIX "NO TEMPO.\n");
		}
		if (params && params->cur_signature) {
			if (params->cur_signature->NextEvent() != NULL) {
				printf(PREFIX "Signatures:\n"); params->cur_signature->PrintChain(0, PREFIX);
			} else {
				printf(PREFIX "Signature: "); params->cur_signature->Print();
			}
		} else {
			printf(PREFIX "NO SIGNATURE.\n");
		}
	} else {
		printf(PREFIX "NO TEMPO OR SIGNATURE.\n");
	}
}

status_t ArpConsoleFilter::GetConfiguration(BMessage* values) const
{
	return AmFilterI::GetConfiguration(values);
}

status_t ArpConsoleFilter::PutConfiguration(const BMessage* values)
{
	return AmFilterI::PutConfiguration(values);
}

/*****************************************************************************
 * ARP-CONSOLE-FILTER-ADD-ON
 *****************************************************************************/
void ArpConsoleFilterAddOn::GetVersion(int32* major, int32* minor) const
{
	*major = 1;
	*minor = 0;
}

BBitmap* ArpConsoleFilterAddOn::Image(BPoint requestedSize) const
{
	const BBitmap* bm = Resources().FindBitmap("Class Icon");
	if (bm) return new BBitmap(bm);
	return NULL;
}

extern "C" _EXPORT AmFilterAddOn* make_nth_filter(int32 n, image_id /*you*/,
												  const void* cookie, uint32 /*flags*/, ...)
{
	if (n == 0) return new ArpConsoleFilterAddOn(cookie);
	return NULL;
}
