/*
 * NameType.cpp
 * This code was written by Tim Vernum.
 * It has been placed in the public domain.
 */

/*
   This program is a simple commandline app for BeOS that allows one to give
   a short name to a mimetype
 */

#include <err.h>
#include <stdio.h>
#include <string.h>

#include <Mime.h>

const int kErrUsage = -1 ;
const int kErrSetFailed = 1 ;

int Usage( char * name )
{
	fprintf( stderr, "%s: <mime-type> <name>\n", name ) ;
	return kErrUsage ;
}

int main( int argc, char ** argv )
{
	if( argc != 3 )
		return Usage( argv[0] ) ;
	
	BMimeType mimetype( argv[1] ) ;
	status_t s ;

	s = mimetype.SetShortDescription( argv[2] ) ;
	if( s != B_OK )
	{
		fprintf( stderr, "Error: Cannot set short description: %s\n", strerror( s ) ) ;
		return kErrSetFailed ;
	}
	
	if( !mimetype.IsInstalled() )
		mimetype.Install() ;
	
	return 0 ;
}

	
		