#include <Entry.h>
#include <Node.h>
#include <File.h>
#include <stdio.h>
#include <string.h>
#include <TypeConstants.h>

int main (int argc, char **argv)
{
	if (argc > 3 || argc < 2)
	{
		fprintf (stderr, 
	"Usage: %s [group] <filename>\n       Generate Person files from list of names\n\
       Format: Firstname M Lastname <email@address>\n", argv[0]);
		return 1;
	}
	
	FILE *fp = fopen (argv[argc - 1], "rb");
	
	bool group = (argc == 3);
	
	while (!feof (fp))
	{
		char line[128];
		char contact[128];
		char name[128];
		char email[128];
		int i, j;
		
		fgets (line, 127, fp);
		if (feof (fp))
			break;
		
		printf ("%s", line);
		for (i = 0; i < strlen (line); i++)
		{
			if (line[i] == '<')
				break;
		}
		strcpy (email, line + i + 1);
		for (j = strlen (email) - 1; j > 0; j--)
		{
			if (email[j] == '>')
			{
				email[j] = 0;
				break;
			}
		}
		
		while (line[i - 1] == ' ' && i > 0)
			i--;
		
		line[i] = 0;	// Terminate the name part
		strcpy (contact, line);
		
		while (line[i] != ' ' && i > 0)
			i--;
		
		strcpy (name, line + i + 1);	// Last name
		strcat (name, ", ");
		
		line[i] = 0;
		strcat (name, line);
		
		BEntry entry (name);
		BFile file = BFile (&entry, B_CREATE_FILE | B_READ_WRITE | B_ERASE_FILE);
		BNode node = BNode (&entry);
		node.WriteAttr ("BEOS:TYPE", B_STRING_TYPE, 0, "application/x-person\0", 21);
		node.WriteAttr ("META:name", B_STRING_TYPE, 0, contact, strlen (contact) + 1);
		node.WriteAttr ("META:email", B_STRING_TYPE, 0, email, strlen (email) + 1);
		if (group)
			node.WriteAttr ("META:group", B_STRING_TYPE, 0, argv[1], strlen (argv[1]) + 1);
	}
	
	fclose (fp);
	
	return 0;
}