/****************************************************************************
** 	CrypticWindow.cpp
**
**	Copyright (C) 2000, Jason Parks <atreyu@acm.org>.  All rights reserved.
**
*****************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <Alert.h>
#include <Box.h>
#include <Button.h>
#include <MenuField.h>
#include <MenuItem.h>
#include <Message.h>
#include <PopUpMenu.h>
#include <RadioButton.h>
#include <StorageKit.h>
#include <String.h>
#include <TextControl.h>
#include <TranslatorRoster.h>
#include <View.h>
#include <Window.h>

#include "CrypticWindow.h"

CrypticWindow::CrypticWindow(BRect frame, entry_ref dir, BMessage *msg)
			  :BWindow(frame, "Cryptic", B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE)
{
	dir_ref = dir; 
	message = msg;	
	
	BBox *box; 
	BButton *button;
	BMenuField *field;
	BPopUpMenu *menu;
	BRadioButton *radio;

	box = new BBox(Bounds(), NULL, B_FOLLOW_ALL);
	box->SetBorder(B_PLAIN_BORDER);
	box->SetViewColor(216, 216, 216);
	
	menu = new BPopUpMenu("Rounds");
	
	BMenuItem *item;
	menu->AddItem(item = new BMenuItem("Blowfish", new BMessage(BLOWFISH)));
	item->SetMarked(true);
	
	field = new BMenuField(BRect(50,10,225,30), "Encryption Field", "Encryption Type:", menu);
	field->SetViewColor(box->ViewColor());
				
	box->AddChild(field);

	radio = new BRadioButton(BRect(75, 40, 132, 60), NULL, "Encrypt", new BMessage(SET_ENCRYPT));
	radio->SetValue(true);
	box->AddChild(radio);
	
	radio = new BRadioButton(BRect(143, 40, 225, 60), NULL, "Decrypt", new BMessage(SET_DECRYPT));
	box->AddChild(radio);

	keyField = new BTextControl(BRect(10, 70, 225, 90), NULL, "Key:", NULL, new BMessage(KEY));
	keyField->SetDivider(40);
	keyField->TextView()->HideTyping(true);
	box->AddChild(keyField);
	
	retypeField = new BTextControl(BRect(10, 100, 225, 120), NULL, "Retype:", NULL, new BMessage(RETYPE));
	retypeField->SetDivider(40);
	retypeField->TextView()->HideTyping(true);
	box->AddChild(retypeField);
		
	button = new BButton(BRect(62, 130, 129, 150), NULL, "Cancel", new BMessage(CANCEL));
	box->AddChild(button);
	
	button = new BButton(BRect(146, 130, 213, 150), NULL, "Ok", new BMessage(OK));
	button->MakeDefault(true);
	box->AddChild(button);
	
	AddChild(box);

	encrypt = true;
	encryptionType = BLOWFISH;
}

void CrypticWindow::MessageReceived(BMessage *msg)
{
	switch(msg->what)
	{
		case BLOWFISH:
		{
			encryptionType = BLOWFISH;
			break;
		}
		case SET_ENCRYPT:
		{
			encrypt = true;
			break;
		}
		case SET_DECRYPT:
		{
			encrypt = false;
			break;
		}
		case OK:
		{
			if(strcmp(keyField->Text(), retypeField->Text()) != 0)
			{
			 	(new BAlert(NULL , "The keys do not match" , "Ok"))->Go();
			}
			else
			{
				//create the default list of translators
				BTranslatorRoster *roster = BTranslatorRoster::Default();
	
				//This BMessage is used to send the BLOWFISHTranslator the key.
				//This BMessage can contain any value for its commnad constant. 
				BMessage *ioExtension = new BMessage(B_ENTER);
				ioExtension->AddString("key", keyField->Text());
	
				uint32 outType = ComputeOutType();
				
				entry_ref ref;
				BFile inFile;
				BFile outFile;
										
				for(int32 count = 0 ; message->FindRef("refs", count, &ref) == B_OK ; count++) 
				{
					inFile.SetTo(&ref, B_READ_ONLY);
					outFile.SetTo(&ref, B_READ_WRITE);
					
					if(inFile.InitCheck() == B_OK && outFile.InitCheck() == B_OK) 
					{
						roster->Translate(&inFile, NULL, ioExtension, &outFile, outType);
					}
				}
				
				Quit();
			}
			
			break;
		}
		case CANCEL:
		{
			Quit();
			break;
		}
		default:
		{
			break;
		}
	}
}

uint32 CrypticWindow::ComputeOutType()
{
	uint32 outType = 0;
	
	if(encrypt)
	{
		switch(encryptionType)
		{
			case BLOWFISH:
				outType = BLOWFISH_ENCRYPT;
				break;
			default:
				break;
		}
	}
	else
	{
		switch(encryptionType)
		{
			case BLOWFISH:
				outType = BLOWFISH_DECRYPT;
				break;
			default:
				break;
		}
	}	
	
	return outType;
}