//functions of ColorWellGadg

#include "colorWellGadg.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myApp.h"
#include "warning.h"
#include "textItem.h"
#include "layoutMatrix.h"


ColorWellGadg	::	~ColorWellGadg() 
{
	delete mpLabelTextItem;
};//end


//ctor--just initialize
ColorWellGadg	::	ColorWellGadg(	const char *	cparamName, 
									uint32			ui32paramMode, 
									uint32			ui32paramFlags,
									uint32			ui32paramColorToChange,
									TextItem *		pparamLabelTextItem) 
				: 
					BView(	BRect(0, 0, COLORWELLWIDTH, COLORWELLHEIGHT), 
							cparamName, 
							ui32paramMode, 
							ui32paramFlags),
					mColorToChange(ui32paramColorToChange),
					mpLabelTextItem(pparamLabelTextItem)
{
	SetViewColor(B_TRANSPARENT_32_BIT);
}//end


void 
ColorWellGadg	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	((MyApp *)be_app)->GetPreferredColorWellGadgetHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	((MyApp *)be_app)->GetPreferredColorWellGadgetLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	((MyApp *)be_app)->GetPreferredColorWellGadgetViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end


void 
ColorWellGadg	::	Draw(	BRect rect) 
{
	BView::Draw(rect);
	SetPenSize(1);
	rgb_color	originalColor(HighColor());
	rgb_color	newColor(originalColor);
	bool		redUp = false;
	bool		greenUp = false;
	bool		blueUp = false;
	BRect 		frame = Bounds();
	int32		stepsDown = frame.IntegerWidth();
	uint8		changeColorBy;
	uint8		colorRange;
	if (originalColor.red < originalColor.green ) 
	{
		if (originalColor.red < originalColor.blue ) 
		{
			redUp = true;
			colorRange = 255 - originalColor.red;
		}
		else
		{
			blueUp = true;
			colorRange = 255 - originalColor.blue;
		}
	}
	else
	{
		if (originalColor.green < originalColor.blue ) 
		{
			greenUp = true;
			colorRange = 255 - originalColor.green;
		}
		else
		{
			blueUp = true;
			colorRange = 255 - originalColor.blue;
		}
	}
	colorRange = colorRange;
	changeColorBy = colorRange / stepsDown;
	for (	int32 i = stepsDown; 
			i > 0; 
			i--)
	{
		if (redUp)
		{
			newColor.red += changeColorBy;
		}
		else 
		{
			if (greenUp)
			{
				newColor.green += changeColorBy;
			}
			else
			{
				newColor.blue += changeColorBy;
			}
		}
		SetHighColor(newColor);
		frame.InsetBy(1, 1);
		StrokeRect(frame);
	}
	SetHighColor(originalColor);
}//end


void 
ColorWellGadg	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case B_PASTE: 
		{
    		rgb_color *		pRGBColor;
    		rgb_color		rgbColor;    		
    		int32  			numRGBBytes = sizeof(struct rgb_color);
	        if (	pparamMessage->FindData(	"RGBColor",
		       									B_RGB_COLOR_TYPE, 
												(void**)&pRGBColor, 
												&numRGBBytes ) == B_OK)
	        {
	           	rgbColor = *pRGBColor;
	            if (	pparamMessage->WasDropped()) 
	            { 
					((MyApp *)be_app)->bPrefChangesMade = true;
	        		beep();//just so feedback occures
					switch (mColorToChange)
					{
						case VIEW_COLOR:
							((MyApp *)be_app)->SetPreferredViewColor(&rgbColor);
						break;
						case HIGH_COLOR:
							((MyApp *)be_app)->SetPreferredHighColor(&rgbColor);
						break;
						case LOW_COLOR:
							((MyApp *)be_app)->SetPreferredLowColor(&rgbColor);
						break;
						case INTGADG_VIEW_COLOR:
							((MyApp *)be_app)->SetPreferredIntGadgetViewColor(&rgbColor);
						break;
						case INTGADG_HIGH_COLOR:
							((MyApp *)be_app)->SetPreferredIntGadgetHighColor(&rgbColor);
						break;
						case INTGADG_LOW_COLOR:
							((MyApp *)be_app)->SetPreferredIntGadgetLowColor(&rgbColor);
						break;
						case COLORWELLGADG_VIEW_COLOR:
							((MyApp *)be_app)->SetPreferredColorWellGadgetViewColor(&rgbColor);
						break;
						case COLORWELLGADG_HIGH_COLOR:
							((MyApp *)be_app)->SetPreferredColorWellGadgetHighColor(&rgbColor);
						break;
						case COLORWELLGADG_LOW_COLOR:
							((MyApp *)be_app)->SetPreferredColorWellGadgetLowColor(&rgbColor);
						break;
						case MYBUTTONGADG_VIEW_COLOR:
							((MyApp *)be_app)->SetPreferredMyButtonGadgetViewColor(&rgbColor);
						break;
						case MYBUTTONGADG_HIGH_COLOR:
							((MyApp *)be_app)->SetPreferredMyButtonGadgetHighColor(&rgbColor);
						break;
						case MYBUTTONGADG_LOW_COLOR:
							((MyApp *)be_app)->SetPreferredMyButtonGadgetLowColor(&rgbColor);
						break;
						default:
							warning("Illegal default colorWellGadg.cpp\n");
						break;
					}
	            }
		 	}
        break;
        }
		default:
			BView::MessageReceived(pparamMessage);
		break;
	}
}//end


TextItem *
ColorWellGadg	::	GetTextItem(void)
{
	return mpLabelTextItem;
}//end



void
ColorWellGadg	::	SetTop(	float fparamTop)
{
	top = fparamTop;
}//end


float
ColorWellGadg	::	GetTop(	void)
{
	return top;
}//end


void
ColorWellGadg	::	SetLeft(	float fparamLeft)
{
	left = fparamLeft;
}//end


float
ColorWellGadg	::	GetLeft(	void)
{
	return left;
}//end