//scrolling pref window


#include "windowGuts.h"
#include "prefWindow.h"
#include <memory>
#include "textItem.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "intGadg.h"
#include "myButtonGadg.h"
#include "warning.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myApp.h"
#include "colorWellGadg.h"
#include "s2uint32.h"

//ctor just initializing
PrefWindow	::	PrefWindow(	BRect			paramBound,
							const char *	ccpparamWindowTitle,
							const char *	ccpparamScrollViewName,
							const char *	ccpparamNamePrefFrame)
			: 
				WindowGuts(	paramBound, 
							ccpparamWindowTitle, 
							ccpparamScrollViewName,
							ccpparamNamePrefFrame)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning("Could not create_sem.\n");
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		BWindow bw(	BRect(0,0,1,1), 
					"noshow", 
					B_DOCUMENT_WINDOW, 
					B_WILL_ACCEPT_FIRST_CLICK);
		auto_ptr<LayoutMatrix> apLayoutMatrix(new LayoutMatrix(&bw, SAMESIZE, 15, 1));//rows,columns
		LayoutMatrix *	pholdLayoutMatrix = apLayoutMatrix.get();
		apLayoutMatrix.release();
		AddToLayoutMatrixList(pholdLayoutMatrix);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apMainViewColorWellGadgText(new TextItem("to set main view color drop a roColor here->"));
		TextItem * pholdMainViewColorWellGadgText = apMainViewColorWellGadgText.get();
		apMainViewColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdMainViewColorWellGadgText);
		auto_ptr<ColorWellGadg> apMainViewColorWellGadg(new ColorWellGadg(	"ColorWellGadgViewColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															VIEW_COLOR,
															pholdMainViewColorWellGadgText));
		ColorWellGadg * pholdMainViewColorWellGadg = apMainViewColorWellGadg.get();
		apMainViewColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdMainViewColorWellGadg);
		auto_ptr<LayoutMatrixItem> apMainViewLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdMainViewColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpMainViewLayoutMatrixItem = apMainViewLayoutMatrixItem.get();
		holdpMainViewLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apMainHighColorWellGadgText(new TextItem("to set main high color drop a roColor here->"));
		TextItem * pholdMainHighColorWellGadgText = apMainHighColorWellGadgText.get();
		apMainHighColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdMainHighColorWellGadgText);
		auto_ptr<ColorWellGadg> apMainHighColorWellGadg(new ColorWellGadg(	"ColorWellGadgHighColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															HIGH_COLOR,
															pholdMainHighColorWellGadgText));
		ColorWellGadg * pholdMainHighColorWellGadg = apMainHighColorWellGadg.get();
		apMainHighColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdMainHighColorWellGadg);
		auto_ptr<LayoutMatrixItem> apMainHighLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdMainHighColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpMainHighLayoutMatrixItem = apMainHighLayoutMatrixItem.get();
		holdpMainHighLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apMainLowColorWellGadgText(new TextItem("to set main low color drop a roColor here->"));
		TextItem * pholdMainLowColorWellGadgText = apMainLowColorWellGadgText.get();
		apMainLowColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdMainLowColorWellGadgText);
		auto_ptr<ColorWellGadg> apMainLowColorWellGadg(new ColorWellGadg(	"ColorWellGadgLowColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															LOW_COLOR,
															pholdMainLowColorWellGadgText));
		ColorWellGadg * pholdMainLowColorWellGadg = apMainLowColorWellGadg.get();
		apMainLowColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdMainLowColorWellGadg);
		auto_ptr<LayoutMatrixItem> apMainLowLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdMainLowColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpMainLowLayoutMatrixItem = apMainLowLayoutMatrixItem.get();
		holdpMainLowLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
/////////////////////////////////////////////////
		auto_ptr<TextItem> apIntGadgViewColorWellGadgText(new TextItem("to set intger gadget view color drop a roColor here->"));
		TextItem * pholdIntGadgViewColorWellGadgText = apIntGadgViewColorWellGadgText.get();
		apIntGadgViewColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdIntGadgViewColorWellGadgText);
		auto_ptr<ColorWellGadg> apIntGadgViewColorWellGadg(new ColorWellGadg(	"ColorWellGadgIntGadgViewColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															INTGADG_VIEW_COLOR,
															pholdIntGadgViewColorWellGadgText));
		ColorWellGadg * pholdIntGadgViewColorWellGadg = apIntGadgViewColorWellGadg.get();
		apIntGadgViewColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdIntGadgViewColorWellGadg);
		auto_ptr<LayoutMatrixItem> apIntGadgViewLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdIntGadgViewColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpIntGadgViewLayoutMatrixItem = apIntGadgViewLayoutMatrixItem.get();
		holdpIntGadgViewLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apIntGadgHighColorWellGadgText(new TextItem("to set intger gadget high color drop a roColor here->"));
		TextItem * pholdIntGadgHighColorWellGadgText = apIntGadgHighColorWellGadgText.get();
		apIntGadgHighColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdIntGadgHighColorWellGadgText);
		auto_ptr<ColorWellGadg> apIntGadgHighColorWellGadg(new ColorWellGadg(	"ColorWellGadgIntGadgHighColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															INTGADG_HIGH_COLOR,
															pholdIntGadgHighColorWellGadgText));
		ColorWellGadg * pholdIntGadgHighColorWellGadg = apIntGadgHighColorWellGadg.get();
		apIntGadgHighColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdIntGadgHighColorWellGadg);
		auto_ptr<LayoutMatrixItem> apIntGadgHighLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdIntGadgHighColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpIntGadgHighLayoutMatrixItem = apIntGadgHighLayoutMatrixItem.get();
		holdpIntGadgHighLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apIntGadgLowColorWellGadgText(new TextItem("to set intger gadget low color drop a roColor here->"));
		TextItem * pholdIntGadgLowColorWellGadgText = apIntGadgLowColorWellGadgText.get();
		apIntGadgLowColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdIntGadgLowColorWellGadgText);
		auto_ptr<ColorWellGadg> apIntGadgLowColorWellGadg(new ColorWellGadg(	"ColorWellGadgIntGadgLowColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															INTGADG_LOW_COLOR,
															pholdIntGadgLowColorWellGadgText));
		ColorWellGadg * pholdIntGadgLowColorWellGadg = apIntGadgLowColorWellGadg.get();
		apIntGadgLowColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdIntGadgLowColorWellGadg);
		auto_ptr<LayoutMatrixItem> apIntGadgLowLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdIntGadgLowColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpIntGadgLowLayoutMatrixItem = apIntGadgLowLayoutMatrixItem.get();
		holdpIntGadgLowLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apColorWellGadgViewColorWellGadgText(new TextItem("to set color well gadget view color drop a roColor here->"));
		TextItem * pholdColorWellGadgViewColorWellGadgText = apColorWellGadgViewColorWellGadgText.get();
		apColorWellGadgViewColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdColorWellGadgViewColorWellGadgText);
		auto_ptr<ColorWellGadg> apColorWellGadgViewColorWellGadg(new ColorWellGadg(	"ColorWellGadgColorWellGadgViewColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															COLORWELLGADG_VIEW_COLOR,
															pholdColorWellGadgViewColorWellGadgText));
		ColorWellGadg * pholdColorWellGadgViewColorWellGadg = apColorWellGadgViewColorWellGadg.get();
		apColorWellGadgViewColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdColorWellGadgViewColorWellGadg);
		auto_ptr<LayoutMatrixItem> apColorWellGadgViewLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdColorWellGadgViewColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpColorWellGadgViewLayoutMatrixItem = apColorWellGadgViewLayoutMatrixItem.get();
		holdpColorWellGadgViewLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apColorWellGadgHighColorWellGadgText(new TextItem("to set color well gadget high color drop a roColor here->"));
		TextItem * pholdColorWellGadgHighColorWellGadgText = apColorWellGadgHighColorWellGadgText.get();
		apColorWellGadgHighColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdColorWellGadgHighColorWellGadgText);
		auto_ptr<ColorWellGadg> apColorWellGadgHighColorWellGadg(new ColorWellGadg(	"ColorWellGadgColorWellGadgHighColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															COLORWELLGADG_HIGH_COLOR,
															pholdColorWellGadgHighColorWellGadgText));
		ColorWellGadg * pholdColorWellGadgHighColorWellGadg = apColorWellGadgHighColorWellGadg.get();
		apColorWellGadgHighColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdColorWellGadgHighColorWellGadg);
		auto_ptr<LayoutMatrixItem> apColorWellGadgHighLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdColorWellGadgHighColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpColorWellGadgHighLayoutMatrixItem = apColorWellGadgHighLayoutMatrixItem.get();
		holdpColorWellGadgHighLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apColorWellGadgLowColorWellGadgText(new TextItem("to set color well gadget low color drop a roColor here->"));
		TextItem * pholdColorWellGadgLowColorWellGadgText = apColorWellGadgLowColorWellGadgText.get();
		apColorWellGadgLowColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdColorWellGadgLowColorWellGadgText);
		auto_ptr<ColorWellGadg> apColorWellGadgLowColorWellGadg(new ColorWellGadg(	"ColorWellGadgColorWellGadgLowColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															COLORWELLGADG_LOW_COLOR,
															pholdColorWellGadgLowColorWellGadgText));
		ColorWellGadg * pholdColorWellGadgLowColorWellGadg = apColorWellGadgLowColorWellGadg.get();
		apColorWellGadgLowColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdColorWellGadgLowColorWellGadg);
		auto_ptr<LayoutMatrixItem> apColorWellGadgLowLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdColorWellGadgLowColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpColorWellGadgLowLayoutMatrixItem = apColorWellGadgLowLayoutMatrixItem.get();
		holdpColorWellGadgLowLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apMyButtonGadgViewColorWellGadgText(new TextItem("to set button gadget view color drop a roColor here->"));
		TextItem * pholdMyButtonGadgViewColorWellGadgText = apMyButtonGadgViewColorWellGadgText.get();
		apMyButtonGadgViewColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdMyButtonGadgViewColorWellGadgText);
		auto_ptr<ColorWellGadg> apMyButtonGadgViewColorWellGadg(new ColorWellGadg(	"ColorWellGadgMyButtonGadgViewColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															MYBUTTONGADG_VIEW_COLOR,
															pholdMyButtonGadgViewColorWellGadgText));
		ColorWellGadg * pholdMyButtonGadgViewColorWellGadg = apMyButtonGadgViewColorWellGadg.get();
		apMyButtonGadgViewColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdMyButtonGadgViewColorWellGadg);
		auto_ptr<LayoutMatrixItem> apMyButtonGadgViewLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdMyButtonGadgViewColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpMyButtonGadgViewLayoutMatrixItem = apMyButtonGadgViewLayoutMatrixItem.get();
		holdpMyButtonGadgViewLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apMyButtonGadgHighColorWellGadgText(new TextItem("to set button gadget high color drop a roColor here->"));
		TextItem * pholdMyButtonGadgHighColorWellGadgText = apMyButtonGadgHighColorWellGadgText.get();
		apMyButtonGadgHighColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdMyButtonGadgHighColorWellGadgText);
		auto_ptr<ColorWellGadg> apMyButtonGadgHighColorWellGadg(new ColorWellGadg(	"ColorWellGadgMyButtonGadgHighColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															MYBUTTONGADG_HIGH_COLOR,
															pholdMyButtonGadgHighColorWellGadgText));
		ColorWellGadg * pholdMyButtonGadgHighColorWellGadg = apMyButtonGadgHighColorWellGadg.get();
		apMyButtonGadgHighColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdMyButtonGadgHighColorWellGadg);
		auto_ptr<LayoutMatrixItem> apMyButtonGadgHighLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdMyButtonGadgHighColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpMyButtonGadgHighLayoutMatrixItem = apMyButtonGadgHighLayoutMatrixItem.get();
		holdpMyButtonGadgHighLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apMyButtonGadgLowColorWellGadgText(new TextItem("to set button gadget low color drop a roColor here->"));
		TextItem * pholdMyButtonGadgLowColorWellGadgText = apMyButtonGadgLowColorWellGadgText.get();
		apMyButtonGadgLowColorWellGadgText.release();
		pholdLayoutMatrix->AddToDraw((void *)pholdMyButtonGadgLowColorWellGadgText);
		auto_ptr<ColorWellGadg> apMyButtonGadgLowColorWellGadg(new ColorWellGadg(	"ColorWellGadgMyButtonGadgLowColorPref", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															MYBUTTONGADG_LOW_COLOR,
															pholdMyButtonGadgLowColorWellGadgText));
		ColorWellGadg * pholdMyButtonGadgLowColorWellGadg = apMyButtonGadgLowColorWellGadg.get();
		apMyButtonGadgLowColorWellGadg.release();
		pholdLayoutMatrix->AddToChildren((void *)pholdMyButtonGadgLowColorWellGadg);
		auto_ptr<LayoutMatrixItem> apMyButtonGadgLowLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdMyButtonGadgLowColorWellGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_COLORWELLGADG));
		LayoutMatrixItem * holdpMyButtonGadgLowLayoutMatrixItem = apMyButtonGadgLowLayoutMatrixItem.get();
		holdpMyButtonGadgLowLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> bigFontMsg(new BMessage(BIGGER_FONT));
		auto_ptr<MyButtonGadg> apBiggerFontMyButtonGadg(new MyButtonGadg(	BRect(0, 20, 1, 1), 
															"localBiggerFontButton", 
															"bigger font", 
															bigFontMsg.get(), 
															B_FOLLOW_NONE, 
															B_WILL_DRAW));
		bigFontMsg.release();
		MyButtonGadg * pholdBiggerFontMyButtonGadg = apBiggerFontMyButtonGadg.get();
		apBiggerFontMyButtonGadg.release();
		pholdBiggerFontMyButtonGadg->SetFont(((MyApp *)be_app)->GetPreferredFont());
		pholdLayoutMatrix->AddToChildren((void *)pholdBiggerFontMyButtonGadg);
		auto_ptr<LayoutMatrixItem> apBiggerFontMyButtonGadgLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdBiggerFontMyButtonGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_BBUTTON));
		LayoutMatrixItem * holdpBiggerFontLayoutMatrixItem = apBiggerFontMyButtonGadgLayoutMatrixItem.get();
		holdpBiggerFontLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> smallFontMsg(new BMessage(SMALLER_FONT));
		auto_ptr<MyButtonGadg> apSmallerFontMyButtonGadg(new MyButtonGadg(	BRect(0, 20, 1, 1), 
																			"localSmallerFontButton", 
																			"smaller font", 
																			smallFontMsg.get(),
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW));
		smallFontMsg.release();
		MyButtonGadg * pholdSmallerFontMyButtonGadg = apSmallerFontMyButtonGadg.get();
		apSmallerFontMyButtonGadg.release();
		pholdSmallerFontMyButtonGadg->SetFont(((MyApp *)be_app)->GetPreferredFont());
		pholdLayoutMatrix->AddToChildren((void *)pholdSmallerFontMyButtonGadg);
		auto_ptr<LayoutMatrixItem> apSmallerFontMyButtonGadgLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdSmallerFontMyButtonGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_BBUTTON));
		LayoutMatrixItem * holdpSmallerFontLayoutMatrixItem = apSmallerFontMyButtonGadgLayoutMatrixItem.get();
		holdpSmallerFontLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	char wrapAtStr[16];
	sprintf(wrapAtStr, "%u", ((MyApp *)be_app)->GetPreferredWrapAt());
	auto_ptr<BMessage> apWrapAtMsg(new BMessage(WRAPAT_INTGADG));
	auto_ptr<IntGadg> apWrapAtIntGadg(new IntGadg(	BRect(10, 100, 300, 110), 
											"WrapAtIntGadg", 
											"set column at which to wrap", 
											wrapAtStr, 
											apWrapAtMsg.get(), 
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE));
	apWrapAtMsg.release();
	IntGadg * pholdIntGadg = (IntGadg *)apWrapAtIntGadg.get();
	apWrapAtIntGadg.release();
	pholdIntGadg->SetFont(((MyApp *)be_app)->GetPreferredFont());
	auto_ptr<LayoutMatrixItem> apWrapAtLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdIntGadg, 
																			pholdLayoutMatrix->itemsList,
																			KIND_INTGADG));
	pholdLayoutMatrix->AddToChildren((void *)pholdIntGadg);
	LayoutMatrixItem * holdpWrapAtLayoutMatrixItem = apWrapAtLayoutMatrixItem.get();
	holdpWrapAtLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//		auto_ptr<BMessage> smallFontMsg(new BMessage(SMALLER_FONT));
//		auto_ptr<TextItem> smallFontTextItem(new TextItem("smaller font"));
//		auto_ptr<MyButtonGadgA> apSmallerFontMyButtonGadgA(new MyButtonGadgA(	/*BRect(0, 20, 1, 1), */
//															"localSmallerFontButton", 
//															/*"smaller font", */
//															smallFontMsg.get(),
//															B_FOLLOW_NONE, 
//															B_WILL_DRAW,
//															smallFontTextItem.get()));
//		smallFontMsg.release();
//		smallFontTextItem.release();
//		MyButtonGadgA * pholdSmallerFontMyButtonGadgA = apSmallerFontMyButtonGadgA.get();
//		apSmallerFontMyButtonGadgA.release();
//		//pholdSmallerFontMyButtonGadgA->SetFont(((MyApp *)be_app)->GetPreferredFont());
//		pholdLayoutMatrix->AddToChildren((void *)pholdSmallerFontMyButtonGadgA);
//		auto_ptr<LayoutMatrixItem> apSmallerFontMyButtonGadgALayoutMatrixItem(new LayoutMatrixItem(	&bw, 
//																			(void *)pholdSmallerFontMyButtonGadgA, 
//																			pholdLayoutMatrix->itemsList,
//																			KIND_MYBUTTON));
//		LayoutMatrixItem * holdpSmallerFontLayoutMatrixItem = apSmallerFontMyButtonGadgALayoutMatrixItem.get();
//		holdpSmallerFontLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
//printf("holdpSmallerFontLayoutMatrixItem widthPref = %f, heightPref = %f\n", holdpSmallerFontLayoutMatrixItem->widthPref, holdpSmallerFontLayoutMatrixItem->heightPref);
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pholdLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, true, calc_sem);
	}
	catch (...)
	{
		warning("caught debug\n");
		//release_sem(calc_sem);//when throwing
		//need to throw again, but don't know how, yet
	}
	BMenuItem *	menuItem;
	BMenu *		firstMenu = new BMenu("File");
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(ABOUT_PREFWINDOW));
		menuItem = new BMenuItem(	"about...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		return;
	}
	firstMenu->AddItem(menuItem);
	pMenuBar->AddItem(firstMenu);
}//end


//dtor
PrefWindow	::	~PrefWindow() 
{
	((MyApp *)be_app)->pPrefWindow = NULL;
}//end


void
PrefWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case BIGGER_FONT:
		{
			((MyApp *)be_app)->bPrefChangesMade = true;
	       	beep();//just so feedback occures
	       	float oldSize = (((MyApp *)be_app)->GetPreferredFont())->Size();
			if (oldSize < 200) 
			{
				oldSize++;
				(((MyApp *)be_app)->GetPreferredFont())->SetSize(oldSize);//this is the window's font
			}
			else
			{
				warning("Font must remain below 200, sorry.\n");
			}
		break;
		}
		case SMALLER_FONT:
		{
			((MyApp *)be_app)->bPrefChangesMade = true;
	       	beep();//just so feedback occures
	       	float oldSize = (((MyApp *)be_app)->GetPreferredFont())->Size();
			if (oldSize > 2) 
			{
				oldSize--;
				(((MyApp *)be_app)->GetPreferredFont())->SetSize(oldSize);//this is the window's font
			}
			else
			{
				warning("Font must remain above 0, sorry.\n");
			}
		break;
		}
		case ABOUT_PREFWINDOW:	
		{
			warning("about pref window\n");
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
PrefWindow	::	QuitRequested() 
{
	BView * pBView = FindView("WrapAtIntGadg");
	if (pBView)
	{
		BTextControl * pWrapAtBTextControl = dynamic_cast<BTextControl *> (pBView);
		if (pWrapAtBTextControl)
		{
			uint32 newWrapAt = s2uint32(pWrapAtBTextControl->Text());
			((MyApp *)be_app)->SetPreferredWrapAt(newWrapAt);
		}
	}
	BRect frame = Frame();
	((MyApp *)be_app)->SetPreferredPreferencesWindowRect(frame);
	return(WindowGuts::QuitRequested());
}//end