//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “BSBar.h”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	BSBar - a remembering BScrollBar with a ValueChanged() port
*/
//====//====//====//====//====//====//====//====//====//====//

#ifndef BSBAR_H
	#define BSBAR_H

	#include <ScrollBar.h>
	class CList;

	class BSBar : public BScrollBar{
	public:
		BSBar(BRect frame, const char *name, \
				port_id drawport, int32 min, int32 max, orientation posture);
		virtual ~BSBar();
		virtual void    ValueChanged(float nv);
		void            ChangeIndex(float mult,void *newindex,float def);
		void            Capture(float mult);
	private:
		float           lastv;      // Last Value
		port_id         drprt;    //Draw Port
		CList           *bflist;    //index list
		CList           *valist;    //Value list
		void           *lastindex;
	};

#endif
