//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “Schemes.cpp”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	A place holder for various color schemes..
*/
//====//====//====//====//====//====//====//====//====//====//

#include <string.h> //strlen()
#include <stdlib.h> //rand() for rcol()

#include <Application.h> //rgb_color
#include "Schemes.h"

rgb_color   rcol();
colscheme *schemetab[3];    //icky
rgb_color col(int32 r,int32 g,int32 b){
	rgb_color cc;
	cc.red=r;
	cc.green=g;
	cc.blue=b;
	return cc;
}

int vvv(char a,char b);
int vvv(char a,char b){
	int aa=0,bb=0;
	if (a>='a' && a<='f')aa=a-'a'+10;
	if (a>='A' && a<='F')aa=a-'A'+10;
	if (a>='0' && a<='9')aa=a-'0';
	if (b>='a' && b<='f')bb=b-'a'+10;
	if (b>='A' && b<='F')bb=b-'A'+10;
	if (b>='0' && b<='9')bb=b-'0';
	return aa*16+bb;
}

rgb_color col(char *src){
	int32   rr=0,gg=0,bb=0;
	if (src && strlen(src)>6){
		rr=vvv(src[1],src[2]);
		gg=vvv(src[3],src[4]);
		bb=vvv(src[5],src[6]);
	}
	return col (rr,gg,bb);
}



rgb_color rcol(){return col (rand()&255,rand()&255,rand()&255);}

void MakeSchemes(){
	static int dead=TRUE;
		//warning! don't use "pure" black, it
		//maps to col 255 (transparent)
	if (dead){
		colscheme *ms;

		for (int i=0;i<3;i++){
			ms=schemetab[i]=new colscheme();
		}

		ms=schemetab[0];
		ms->background=col("#0A0A0A"); //See above!
		ms->greycursor=col(120,120,120);
		ms->redcursor=col(150,0,0);
		ms->greencursor=col(0,120,0);
		ms->bluecursor=col(30,30,120);

		char *DarkStyle[]={
				"#F4E020","#DFE4E1","#FF3474",
				"#ACC3FF","#ECAD6E","#F4E020",
				"#53FBAB","#B8DB8A","#FFFFFF",
				"#FF8494","#A8DFEf","#DCADBE", //comment,maileven,mailodd
				"#ACC3FF","#ACC3FF","#2FFF62",
				"-1"};

		int32 cc=0;
		for (int i=0;i<30;i++){
			rgb_color   nc=ms->style[0];
			if (DarkStyle[cc][0]=='#'){
				nc=col(DarkStyle[cc++]);
			}
			ms->style[i]=nc;
		}

		ms=schemetab[1];
		ms->background=col(255,255,255);
		ms->greycursor=col(220,220,220);
		ms->redcursor=col(255,200,200);
		ms->greencursor=col(200,255,200);
		ms->bluecursor=col(200,200,255);
		ms->style[0]=col(10,10,10); //See above!
		ms->style[1]=col(100,100,100);
		ms->style[2]=col(140,0,0);
		ms->style[3]=col(0,30,140);
		ms->style[4]=col(0,110,80);
		ms->style[5]=col(20,140,0);

		ms=schemetab[2];
		ms->background=rcol();
		ms->greycursor=rcol();
		ms->redcursor=rcol();
		ms->greencursor=rcol();
		ms->bluecursor=rcol();

		dead=FALSE;
	}
}
