/********************************************
	By:
	Serge Beauchamp
	
	Version 1.0, Utf8 Unicode system
	
	Made with :
		BeOS DR9.2 (PR2)
		Metrowerks CodeWarrior for BeOS R3
		BeIDE v1.4
	
	Copyright 1997.
	All rights reserved.

	contact:
		beaus07@carouge.dmi.usherb.ca
*********************************************/


/////////////////////////////////////////////
// Declaration de la classe GrowingArray
/////////////////////////////////////////////

#define kIncrementFactor 128

template <class TYPE>
class GrowingArray
{
	protected:
		TYPE * ptr;
		int number;
		int max;
	public:
		virtual int Add(TYPE *et) {
			if (max == number)
			{
				TYPE *tmp = new TYPE[max + kIncrementFactor];
				if (tmp == 0)
					return -1;
					
				for (int i = 0;i < number;i++)
					tmp[i] = ptr[i];
					
				delete [] ptr;
				ptr = tmp;
				max += kIncrementFactor;
			}
		
			ptr[number++] = *et;
			return (number -1);
		}

		void Get(int index,TYPE *et) {
			if ((index != -1) && (index < number))
				*et = ptr[index];
		}
		
		void Set(int index,TYPE *et) {
			if ((index != -1) && (index < number))
				ptr[index] = *et;
		}

		TYPE * Get(int index) {
			if ((index != -1) && (index < number))
				return ptr + index;
			else
				return NULL;
		}
		int GetSize() {
			return number;
		}
		
		GrowingArray<TYPE> & operator= (	GrowingArray<TYPE> & codeL) {
			if (ptr)
				delete [] ptr;
		
			ptr = codeL.ptr;
			number = codeL.number;
			max = codeL.max;
		
			if (max)
			{		
				ptr = new TYPE[max];
					
				for (int i = 0;i < number;i++)
					ptr[i] = codeL.ptr[i];
			}
			return *this;
		}

		GrowingArray() {
			ptr = 0;
			number = 0;
			max = 0;
		}
		~GrowingArray() {
			if (ptr)
				delete [] ptr;
		}
};

