#ifndef __as_approx_hh__
#define __as_approx_hh__

struct dist_weights {
  double del1;
  double del2;
  double swaps;
  double subs;
  dist_weights() {}
  dist_weights(double d1, double d2, double sw, double su) 
    : del1(d1), del2(d2), swaps(sw), subs(su) {}
  void set(double d1, double d2, double sw, double su) 
    {del1=d1; del2=d2; swaps=sw; subs=su;}
};

struct dist_components {
  int del1;
  int del2;
  int swaps;
  int subs;
  dist_components() {}
  dist_components(int d1, int d2, int sw, int su) 
    : del1(d1), del2(d2), swaps(sw), subs(su) {}
  void set (int d1, int d2, int sw, int su) 
    {del1 = d1; del2 = d2; swaps = sw; subs = su;}
};

double approx_match_score_fast(const char *s1, const char *s2);
int approx_match_dist_fast(const char *s1, const char *s2);
void approx_match_fast(const char *s1, const char *s2,
		       double &score, int &dist);


double approx_match_score_simple(const char *s1, const char *s2);
int approx_match_dist_simple(const char *s1, const char *s2);
void approx_match_simple(const char *s1, const char *s2,
			 double &score, double &dist);

double approx_match_score(const char *s1, const char *s2);
double approx_match_dist(const char *s1, const char *s2);
void approx_match(const char *s1, const char *s2,
		  double &score, double &dist);

double approx_match_score(const char *s1, const char *s2, 
			  const dist_weights&);
double approx_match_dist(const char *s1, const char *s2,
			   const dist_weights&);
void approx_match(const char *s1, const char *s2,
		  double &score, double &dist, 
		  const dist_weights&);

void approx_match(const char *s1, const char *s2,
		  dist_components&);

#endif
