#ifndef __as_config__
#define __as_config__

#include "string_map.hh"

class ConfigData : public StringMap {
protected:
  StringMap is_default;
  ConfigData();
public:
  ConfigData(const string & file);

  bool read_in_file(const string & file);

  virtual bool insert(const string & key, const string & value);
  virtual bool def(const string & key, const string & value);
  virtual bool replace(const string & key, const string & value);
};

class AspellConfig : public ConfigData {
private:
  void read_in(const StringMap & override);
  void possible_env(const string & env_name, const string & name);
public:
  AspellConfig();
  AspellConfig(const string & override);
  AspellConfig(const StringMap & override);

  bool write_to_stream(ostream &) const;

  void compute_defaults();

  static const char * help (const string &);
};

#endif
