// Aspell word list conversion functions
// Copyright 1998 by Kevin Atkinson under the terms of the LGPL

#ifndef __as_convert__
#define __as_convert__

#include "language.hh"
#include "config.hh"

class SCC_WordList_Internal;

struct SCC_WordList {
  SCC_WordList_Internal* internal;

  SCC_WordList();
  ~SCC_WordList();
  bool add(const string &str);
};

void  create_master2 (const string &base, unsigned int size, 
		      SCC_WordList &wl, const SC_Language *lang);

template <class InputIterator>
void create_master(const AspellConfig * config,
		   const InputIterator begin, 
		   const InputIterator end)
{
  SC_Language lang(config->lookup("lang"), config);
  create_master(config->lookup("master-path"), begin, end, &lang);
}

template <class InputIterator>
void create_master(const string base, 
		   const InputIterator begin, 
		   const InputIterator end,
		   const SC_Language *lang) {
  SCC_WordList word_list;
  
  unsigned int size = 0;

  for (InputIterator i = begin; i != end; ++i) {
    if (word_list.add(*i)) {
      size += (*i).size() + 1;
    }
  }
  create_master2(base, size, word_list, lang);
}

#endif

