#include "copy_ptr.hh"

template <typename Class> 
copy_ptr<Class>::copy_ptr(const copy_ptr<Class> &other) {
  if (other.own) 
    ptr = new Class(*other.ptr);
  else
    ptr = other.ptr;
  own = other.own;
}

template <typename Class>
  copy_ptr<Class> & 
  copy_ptr<Class>::operator= (const copy_ptr<Class> & other) 
{
  if (own) delete ptr;
  if (other.own) 
    ptr = new Class(*other.ptr);
  else
    ptr = other.ptr;
  own = other.own;
  return *this;
}

template <typename Class>
copy_ptr<Class>::~copy_ptr() {
  if (own) delete ptr;
}
