#ifndef aspell_data_hh__
#define aspell_data_hh__

#include "data_base.hh"

class ReadOnlyWL : public StandardWL_Base
{
private:
  struct Internal;
  Internal *internal;
private:
  ReadOnlyWL(const ReadOnlyWL&);
  ReadOnlyWL& operator= (const ReadOnlyWL&);
public:
  const_iterator begin() const;
  const_iterator end() const;
  size_type size() const;
  bool empty() const;
  
  ReadOnlyWL();
  ~ReadOnlyWL();
  void load(const string &, const AspellConfig *);
  const char * file_name() const;
  bool operator [] (const char *word) const;
  bool operator [] (const string &word) const;

  const WordList words_w_soundslike(const char *word) const; 
};


class WritableWL : public WritableWL_Base
{
  struct Internal;
  Internal * internal;
public:
  const_iterator begin() const;
  const_iterator end() const;
  size_type      size() const;
  bool           empty() const;
  
  WritableWL();
  ~WritableWL();
  void load(const string &, const AspellConfig *);
  void merge(const string &);
  void update();
  void save();
  void save_as(const string &);
  const char * file_name() const;
  void add(const string &w);
  void add(const string &w, const string &s);
  void clear();
  bool operator [] (const char *word) const;
  bool operator [] (const string &word) const;

  const WordList words_w_soundslike(const char *word) const; 
};

class WritableReplList : public ReplacementsWL_Base
{
private:
  struct Internal;
  Internal * internal;
  class RealReplacements {
    vector<string> info;
  public:
    typedef vector<string>::const_iterator const_iterator;
    typedef const_iterator                 iterator;
    typedef vector<string>::size_type      size_type;
    RealReplacements() : info(1) {}
    RealReplacements(const string &mis, size_type num)
      {info.reserve(num+1); info.push_back(mis);}
    RealReplacements(const string &mis, const string &cor) : info(2) 
      {info[0] = mis; info[1] = cor;}
    const string& misspelled_word() const {return info[0];}
    const_iterator begin() const {return info.begin()+1;}
    const_iterator end()   const {return info.end();}
    size_type      size()  const {return info.size()-1;}
    bool add(const string &);
    void add_nocheck(const string &r) {info.push_back(r);}
    bool erase(const string &);
    bool exists(const string &);
  };
private:
  WritableReplList(const WritableReplList&);
  WritableReplList& operator=(const WritableReplList&);
public:
  WritableReplList();
  ~WritableReplList();

  const_iterator begin() const;
  const_iterator end() const;
  size_type size() const;
  bool empty() const;
  
  void load(const string &, const AspellConfig *);
  void merge(const string &);
  void update();
  void save();
  void save_as(const string &);
  void clear();
  const char * file_name();
  
  void add(const string &mis, const string &cor);
  void add(const string &mis, const string &cor, const string &s);

  const WordList words_w_soundslike(const char *word) const;
};

#endif
