// hash_string
// Copyright 1998 by Kevin Atkinson under the terms of the LGPL

#ifndef __hash_string_hh__
#define __hash_string_hh__

template<class String>
struct hash_string {
  typedef size_t         result_type;
  typedef const String & argument_type;

  inline size_t operator() (const String &str) const {
    unsigned long h = 0;
    for (string::const_iterator s = str.begin(); s != str.end(); ++s)
      h=5*h + *s;
    return size_t(h);
  }
};

template<class Con>
struct is_nonexistent_container {
  typedef bool         result_type;
  typedef const Con &  argument_type;

  bool operator() (const Con &i) const {return i.empty();}
};

template<class Con>
struct make_nonexistent_container {
  typedef void    result_type;
  typedef Con &   argument_type;

  void operator() (Con &i) const {i.resize(0);}
};

#endif
