
class SC_Language;

template <typename Itr, typename EndF>
class tok {
public:
  typedef Itr  real_itr;
  typedef EndF end_f;

  struct token {
    bool      is_word;
    real_itr  begin;
    real_itr  end;
  };

private:
  token               cur_token;
  end_f               endf_;
  const SC_Language * lang;

public:
  tok(const real_itr & i, const end_f & e, const SC_Language & l) 
    : endf_(e), lang(&l) {cur_token.end = i; operator++();}
  
  const token & operator* () const {return cur_token;}
  
  tok& operator++();
  tok operator++(int) {tok temp = *this; operator++(); return temp;}

  bool at_end() const {return endf_(cur_token.begin);}

};
  

  
