/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class ScrollPane
extends Container
implements AdjustmentListener {
    private static final long serialVersionUID = 7956609840827222915L;
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    int policy;
    SPAdjustable hScroll;
    SPAdjustable vScroll;
    Point pos;
    Component child;
    ChildWrapper wrapper;

    protected final void addImpl(Component component, Object object, int n) {
        if (component != this.hScroll && component != this.vScroll) {
            if (this.child != null) {
                this.remove(this.child);
            }
            this.child = component;
            ScrollPane scrollPane = this;
            if (scrollPane == null) {
                throw null;
            }
            this.wrapper = scrollPane.new ChildWrapper();
            this.wrapper.add(component);
            super.addImpl(this.wrapper, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n;
        if (this.child == null) {
            return;
        }
        Object object = adjustmentEvent.getSource();
        int n2 = adjustmentEvent.getValue();
        int n3 = this.wrapper.width;
        int n4 = this.wrapper.height;
        if (object == this.vScroll) {
            n = n2 - this.pos.y;
            this.pos.y = n2;
        } else {
            n = n2 - this.pos.x;
            this.pos.x = n2;
        }
        this.child.flags &= 0xFFFFFFFE;
        this.child.setLocation(-this.pos.x, -this.pos.y);
        this.child.flags |= 1;
        Graphics graphics = this.wrapper.getGraphics();
        if (graphics != null) {
            if (object == this.vScroll) {
                if (n > 0) {
                    graphics.copyArea(0, n, n3, n4 - n, 0, -n);
                    graphics.setClip(0, n4 - n, n3, n);
                } else {
                    graphics.copyArea(0, 0, n3, n4 + n, 0, -n);
                    graphics.setClip(0, 0, n3, -n);
                }
            } else if (n > 0) {
                graphics.copyArea(n, 0, n3 - n, n4, -n, 0);
                graphics.setClip(n3 - n, 0, n, n4);
            } else {
                graphics.copyArea(0, 0, n3 + n, n4, -n, 0);
                graphics.setClip(0, 0, -n, n4);
            }
            this.wrapper.update(graphics);
            graphics.dispose();
        }
    }

    void checkScrollbarVisibility(Dimension dimension) {
        int n = 2;
        int n2 = this.width - 2 * n;
        int n3 = this.height - 2 * n;
        if ((this.hScroll.flags & 1) != 0) {
            if (dimension.width <= n2) {
                this.hScroll.setVisible(false);
            }
        } else if (dimension.width > n2) {
            this.hScroll.setVisible(true);
        }
        if ((this.vScroll.flags & 1) != 0) {
            if (dimension.height <= n3) {
                this.vScroll.setVisible(false);
            }
        } else if (dimension.height > n3) {
            this.vScroll.setVisible(true);
        }
    }

    public void doLayout() {
        this.layout();
    }

    public Adjustable getHAdjustable() {
        return this.hScroll;
    }

    public int getHScrollbarHeight() {
        return this.hScroll == null ? 0 : Defaults.ScrollbarWidth;
    }

    public Point getScrollPosition() {
        return this.pos;
    }

    public int getScrollbarDisplayPolicy() {
        return this.policy;
    }

    public Adjustable getVAdjustable() {
        return this.vScroll;
    }

    public int getVScrollbarWidth() {
        return this.vScroll == null ? 0 : Defaults.ScrollbarWidth;
    }

    public Dimension getViewportSize() {
        return new Dimension(this.width - (this.insets.left + this.insets.right), this.height - (this.insets.top + this.insets.bottom));
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void layout() {
        if (this.child == null) {
            return;
        }
        int n = 2;
        int n2 = Defaults.ScrollbarWidth;
        Dimension dimension = this.child.getPreferredSize();
        this.flags |= 8;
        if (this.policy == 0) {
            this.checkScrollbarVisibility(dimension);
        }
        int n3 = (this.vScroll.flags & 1) != 0 ? n2 : 0;
        int n4 = (this.hScroll.flags & 1) != 0 ? n2 : 0;
        int n5 = this.width - (2 * n + n3);
        int n6 = this.height - (2 * n + n4);
        this.hScroll.setBounds(0, this.height - n2, this.width - n3, n2);
        this.vScroll.setBounds(this.width - n2, 0, n2, this.height - n4);
        this.hScroll.setValues(0, n5, 0, dimension.width);
        this.vScroll.setValues(0, n6, 0, dimension.height);
        this.wrapper.setBounds(n, n, this.width - n3 - 2 * n, this.height - n4 - 2 * n);
        this.child.setBounds(0, 0, dimension.width, dimension.height);
        this.flags &= 0xFFFFFFF7;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2 = Defaults.ScrollbarWidth;
        int n3 = (this.vScroll.flags & 1) != 0 ? n2 : 0;
        int n4 = n = (this.hScroll.flags & 1) != 0 ? n2 : 0;
        if (this.wrapper != null) {
            graphics.paintChild(this.wrapper, false);
        }
        if (n != 0) {
            graphics.paintChild(this.hScroll, false);
        }
        if (n3 != 0) {
            graphics.paintChild(this.vScroll, false);
        }
        this.paintBorder(graphics, 0, 0, n3, n);
    }

    public final void setLayout(LayoutManager layoutManager) {
        throw new AWTError("ScrollPane can't have LayoutManagers");
    }

    public void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    public void setScrollPosition(int n, int n2) {
        this.pos.x = n;
        this.pos.y = n2;
        this.hScroll.setValue(n);
        this.vScroll.setValue(n2);
    }

    public ScrollPane() {
        this(0);
    }

    public ScrollPane(int n) {
        int n2 = 2;
        this.layoutm = null;
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("illegal ScrollPane policy");
        }
        this.policy = n;
        this.pos = new Point();
        ScrollPane scrollPane = this;
        if (scrollPane == null) {
            throw null;
        }
        this.hScroll = scrollPane.new SPAdjustable(0);
        ScrollPane scrollPane2 = this;
        if (scrollPane2 == null) {
            throw null;
        }
        this.vScroll = scrollPane2.new SPAdjustable(1);
        this.add(this.hScroll);
        this.add(this.vScroll);
        this.hScroll.addAdjustmentListener(this);
        this.vScroll.addAdjustmentListener(this);
        if (n != 1) {
            this.hScroll.flags &= 0xFFFFFFFE;
            this.vScroll.flags &= 0xFFFFFFFE;
        }
    }

    class SPAdjustable
    extends Scrollbar {
        public void setMaximum(int n) {
            throw new AWTError("can't set scroll maximum for ScrollPane");
        }

        public void setMinimum(int n) {
            throw new AWTError("can't set scroll minimum for ScrollPane");
        }

        public void setVisibleAmount(int n) {
            throw new AWTError("can't set visible amount for ScrollPane");
        }

        SPAdjustable(int n) {
            super(n);
        }
    }

    class ChildWrapper
    extends Container {
        public void doLayout() {
        }

        public void paint(Graphics graphics) {
            graphics.paintChild(ScrollPane.this.child, false);
        }

        ChildWrapper() {
            this.layoutm = null;
        }
    }
}

