/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.FlushThread;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.ImageNativeProducer;
import java.awt.NativeClipboard;
import java.awt.NativeCollector;
import java.awt.PSPrintJob;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.WMEvent;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.WindowPeer;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import kaffe.util.Ptr;
import kaffe.util.log.LogClient;
import kaffe.util.log.LogStream;

public class Toolkit {
    static Toolkit singleton;
    static Dimension screenSize;
    static int resolution;
    static EventQueue eventQueue;
    static EventDispatchThread eventThread;
    static NativeClipboard clipboard;
    static ColorModel colorModel;
    static LightweightPeer lightweightPeer;
    static WindowPeer windowPeer;
    static FlushThread flushThread;
    static NativeCollector collectorThread;
    static int flags;
    static final int FAILED = -1;
    static final int IS_BLOCKING = 1;
    static final int IS_DISPATCH_EXCLUSIVE = 2;
    static final int NEEDS_FLUSH = 4;
    static final int NATIVE_DISPATCHER_LOOP = 8;
    static final int EXTERNAL_DECO = 16;
    private static /* synthetic */ Class class$Ljava$awt$Toolkit;

    public void beep() {
        Toolkit.tlkBeep();
    }

    static synchronized native void cbdFreeClipboard(Ptr var0);

    static synchronized native Transferable cbdGetContents(Ptr var0);

    static synchronized native Ptr cbdInitClipboard();

    static synchronized native boolean cbdSetOwner(Ptr var0);

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return image.checkImage(n, n2, imageObserver, false);
    }

    static synchronized native long clrBright(int var0);

    static synchronized native long clrDark(int var0);

    static synchronized native ColorModel clrGetColorModel();

    static synchronized native int clrGetPixelValue(int var0);

    static synchronized native int clrSetSystemColors(int[] var0);

    public Image createImage(ImageProducer imageProducer) {
        return new Image(imageProducer);
    }

    public Image createImage(byte[] byArray) {
        return this.createImage(byArray, 0, byArray.length);
    }

    public Image createImage(byte[] byArray, int n, int n2) {
        return new Image(byArray, n, n2);
    }

    ComponentPeer createLightweight(Component component) {
        return lightweightPeer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void createNative(Component component) {
        WMEvent wMEvent = null;
        Serializable serializable = class$Ljava$awt$Toolkit != null ? class$Ljava$awt$Toolkit : (class$Ljava$awt$Toolkit = Toolkit.class$("java.awt.Toolkit"));
        // MONITORENTER : serializable
        if (eventThread == null) {
            Toolkit.startDispatch();
        }
        // MONITOREXIT : serializable
        if ((flags & 2) == 0) {
            component.createNative();
            return;
        }
        if ((flags & 8) != 0) {
            if (Thread.currentThread() != collectorThread) {
                wMEvent = WMEvent.getEvent(component, 1901);
                Toolkit.evtSendWMEvent(wMEvent);
            }
        } else if (Thread.currentThread() != eventThread) {
            wMEvent = WMEvent.getEvent(component, 1901);
            eventQueue.postEvent(wMEvent);
        }
        if (wMEvent == null) return;
        while (component.getNativeData() == null) {
            serializable = wMEvent;
            // MONITORENTER : serializable
            try {
                wMEvent.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected WindowPeer createWindow(Window window) {
        return windowPeer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void destroyNative(Component component) {
        WMEvent wMEvent = null;
        if ((flags & 2) == 0) {
            component.destroyNative();
            return;
        }
        if ((flags & 8) != 0) {
            if (Thread.currentThread() != collectorThread) {
                wMEvent = WMEvent.getEvent(component, 1902);
                Toolkit.evtSendWMEvent(wMEvent);
            }
        } else if (Thread.currentThread() != eventThread) {
            wMEvent = WMEvent.getEvent(component, 1902);
            eventQueue.postEvent(wMEvent);
        }
        if (wMEvent == null) return;
        while (component.getNativeData() != null) {
            WMEvent wMEvent2 = wMEvent;
            // MONITORENTER : wMEvent2
            try {
                wMEvent.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    static synchronized native AWTEvent evtGetNextEvent();

    static synchronized native Component[] evtInit();

    static synchronized native AWTEvent evtPeekEvent();

    static synchronized native AWTEvent evtPeekEventId(int var0);

    static synchronized native int evtRegisterSource(Ptr var0);

    static synchronized native void evtSendWMEvent(WMEvent var0);

    static synchronized native int evtUnregisterSource(Ptr var0);

    static synchronized native void evtWakeup();

    static synchronized native int fntBytesWidth(Ptr var0, byte[] var1, int var2, int var3);

    static synchronized native int fntCharWidth(Ptr var0, char var1);

    static synchronized native int fntCharsWidth(Ptr var0, char[] var1, int var2, int var3);

    static synchronized native void fntFreeFont(Ptr var0);

    static synchronized native void fntFreeFontMetrics(Ptr var0);

    static synchronized native int fntGetAscent(Ptr var0);

    static synchronized native int fntGetDescent(Ptr var0);

    static synchronized native int fntGetFixedWidth(Ptr var0);

    static synchronized native int fntGetHeight(Ptr var0);

    static synchronized native int fntGetLeading(Ptr var0);

    static synchronized native int fntGetMaxAdvance(Ptr var0);

    static synchronized native int fntGetMaxAscent(Ptr var0);

    static synchronized native int fntGetMaxDescent(Ptr var0);

    static synchronized native int[] fntGetWidths(Ptr var0);

    static synchronized native Ptr fntInitFont(String var0, int var1, int var2);

    static synchronized native Ptr fntInitFontMetrics(Ptr var0);

    static synchronized native boolean fntIsWideFont(Ptr var0);

    static synchronized native int fntStringWidth(Ptr var0, String var1);

    public ColorModel getColorModel() {
        if (colorModel == null) {
            colorModel = Toolkit.clrGetColorModel();
        }
        return colorModel;
    }

    public static Toolkit getDefaultToolkit() {
        return singleton;
    }

    public String[] getFontList() {
        String[] stringArray = new String[]{"Default", "Monospaced", "SansSerif", "Serif", "Dialog", "DialogInput", "ZapfDingbats"};
        return stringArray;
    }

    public FontMetrics getFontMetrics(Font font) {
        return FontMetrics.getFontMetrics(font);
    }

    public Image getImage(String string) {
        File file = new File(string);
        return file.exists() ? new Image(file) : Image.getUnknownImage();
    }

    public Image getImage(URL uRL) {
        return new Image(uRL);
    }

    public int getMenuShortcutKeyMask() {
        return 2;
    }

    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        return new PSPrintJob(frame, string, properties);
    }

    public static String getProperty(String string, String string2) {
        return null;
    }

    public Dimension getScreenSize() {
        return screenSize;
    }

    public Clipboard getSystemClipboard() {
        if (clipboard == null) {
            clipboard = new NativeClipboard();
        }
        return clipboard;
    }

    public EventQueue getSystemEventQueue() {
        return eventQueue;
    }

    static synchronized native void graAddClip(Ptr var0, int var1, int var2, int var3, int var4);

    static synchronized native void graClearRect(Ptr var0, int var1, int var2, int var3, int var4);

    static synchronized native void graCopyArea(Ptr var0, int var1, int var2, int var3, int var4, int var5, int var6);

    static synchronized native void graDraw3DRect(Ptr var0, int var1, int var2, int var3, int var4, boolean var5, int var6);

    static synchronized native void graDrawArc(Ptr var0, int var1, int var2, int var3, int var4, int var5, int var6);

    static synchronized native void graDrawBytes(Ptr var0, byte[] var1, int var2, int var3, int var4, int var5);

    static synchronized native void graDrawChars(Ptr var0, char[] var1, int var2, int var3, int var4, int var5);

    static synchronized native void graDrawImage(Ptr var0, Ptr var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    static synchronized native void graDrawImageScaled(Ptr var0, Ptr var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    static synchronized native void graDrawLine(Ptr var0, int var1, int var2, int var3, int var4);

    static synchronized native void graDrawOval(Ptr var0, int var1, int var2, int var3, int var4);

    static synchronized native void graDrawPolygon(Ptr var0, int[] var1, int[] var2, int var3);

    static synchronized native void graDrawPolyline(Ptr var0, int[] var1, int[] var2, int var3);

    static synchronized native void graDrawRect(Ptr var0, int var1, int var2, int var3, int var4);

    static synchronized native void graDrawRoundRect(Ptr var0, int var1, int var2, int var3, int var4, int var5, int var6);

    static synchronized native void graDrawString(Ptr var0, String var1, int var2, int var3);

    static synchronized native void graFill3DRect(Ptr var0, int var1, int var2, int var3, int var4, boolean var5, int var6);

    static synchronized native void graFillArc(Ptr var0, int var1, int var2, int var3, int var4, int var5, int var6);

    static synchronized native void graFillOval(Ptr var0, int var1, int var2, int var3, int var4);

    static synchronized native void graFillPolygon(Ptr var0, int[] var1, int[] var2, int var3);

    static synchronized native void graFillRect(Ptr var0, int var1, int var2, int var3, int var4);

    static synchronized native void graFillRoundRect(Ptr var0, int var1, int var2, int var3, int var4, int var5, int var6);

    static synchronized native void graFreeGraphics(Ptr var0);

    static synchronized native Ptr graInitGraphics(Ptr var0, Ptr var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Ptr var9, int var10, int var11, boolean var12);

    static synchronized native void graSetBackColor(Ptr var0, int var1);

    static synchronized native void graSetClip(Ptr var0, int var1, int var2, int var3, int var4);

    static synchronized native void graSetColor(Ptr var0, int var1);

    static synchronized native void graSetFont(Ptr var0, Ptr var1);

    static synchronized native void graSetOffset(Ptr var0, int var1, int var2);

    static synchronized native void graSetPaintMode(Ptr var0);

    static synchronized native void graSetVisible(Ptr var0, boolean var1);

    static synchronized native void graSetXORMode(Ptr var0, int var1);

    static synchronized native void imgComplete(Ptr var0, int var1);

    static synchronized native Ptr imgCreateFromData(byte[] var0, int var1, int var2);

    static synchronized native Ptr imgCreateFromFile(String var0);

    static synchronized native Ptr imgCreateImage(int var0, int var1);

    static synchronized native Ptr imgCreateScaledImage(Ptr var0, int var1, int var2);

    static synchronized native Ptr imgCreateScreenImage(int var0, int var1);

    static synchronized native void imgFreeImage(Ptr var0);

    static synchronized native int imgGetHeight(Ptr var0);

    static synchronized native int imgGetLatency(Ptr var0);

    static synchronized native Ptr imgGetNextFrame(Ptr var0);

    static synchronized native int imgGetWidth(Ptr var0);

    static synchronized native boolean imgIsMultiFrame(Ptr var0);

    static synchronized native void imgProduceImage(ImageNativeProducer var0, Ptr var1);

    static synchronized native Ptr imgSetFrame(Ptr var0, int var1);

    static synchronized native void imgSetIdxPels(Ptr var0, int var1, int var2, int var3, int var4, int[] var5, byte[] var6, int var7, int var8, int var9);

    static synchronized native void imgSetRGBPels(Ptr var0, int var1, int var2, int var3, int var4, int[] var5, int var6, int var7);

    static synchronized void initToolkit() {
        screenSize = new Dimension(Toolkit.tlkGetScreenWidth(), Toolkit.tlkGetScreenHeight());
        resolution = Toolkit.tlkGetResolution();
        singleton = new Toolkit();
        eventQueue = new EventQueue();
        if ((flags & 8) != 0) {
            (class$Ljava$awt$Toolkit != null ? class$Ljava$awt$Toolkit : (class$Ljava$awt$Toolkit = Toolkit.class$("java.awt.Toolkit"))).notify();
        }
    }

    protected void loadSystemColors(int[] nArray) {
        Toolkit.clrSetSystemColors(nArray);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return Image.loadImage(image, n, n2, imageObserver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void redirectStreams() {
        try {
            LogClient logClient = (LogClient)Class.forName(Defaults.ConsoleClass).newInstance();
            LogStream logStream = new LogStream(30, logClient);
            logClient.enable();
            System.setOut(new PrintStream(logStream));
            System.setErr(System.out);
            System.out.println("Java console enabled");
            return;
        }
        catch (Exception exception) {
            System.err.println("unable to redirect out, err");
            exception.printStackTrace();
        }
    }

    static synchronized void startDispatch() {
        if (eventThread == null) {
            eventThread = new EventDispatchThread(eventQueue);
            eventThread.start();
            if (Defaults.ConsoleClass != null) {
                Toolkit.redirectStreams();
            }
        }
        if ((flags & 4) != 0 && flushThread == null) {
            flushThread = new FlushThread(Defaults.GraFlushRate);
            flushThread.start();
        }
    }

    static synchronized void stopDispatch() {
        if (eventThread != null) {
            eventThread.stopDispatching();
            eventThread = null;
        }
        if (flushThread != null) {
            flushThread.stopFlushing();
            flushThread = null;
        }
    }

    public void sync() {
        Toolkit.tlkSync();
    }

    static void terminate() {
        if (clipboard != null) {
            clipboard.dispose();
        }
        Toolkit.stopDispatch();
        Toolkit.tlkTerminate();
    }

    static synchronized native void tlkBeep();

    static synchronized native void tlkDisplayBanner(String var0);

    static synchronized native void tlkFlush();

    static synchronized native int tlkGetResolution();

    static synchronized native int tlkGetScreenHeight();

    static synchronized native int tlkGetScreenWidth();

    static native boolean tlkInit(String var0);

    static synchronized native int tlkProperties();

    static synchronized native void tlkSync();

    static synchronized native void tlkTerminate();

    static synchronized native String tlkVersion();

    static synchronized native Ptr wndCreateDialog(Ptr var0, String var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    static synchronized native Ptr wndCreateFrame(String var0, int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    static synchronized native Ptr wndCreateWindow(Ptr var0, int var1, int var2, int var3, int var4, int var5, int var6);

    static synchronized native void wndDestroyWindow(Ptr var0);

    static synchronized native void wndRepaint(Ptr var0, int var1, int var2, int var3, int var4);

    static synchronized native void wndRequestFocus(Ptr var0);

    static synchronized native void wndSetBounds(Ptr var0, int var1, int var2, int var3, int var4, boolean var5);

    static synchronized native void wndSetCursor(Ptr var0, int var1);

    static synchronized native int wndSetDialogInsets(int var0, int var1, int var2, int var3);

    static synchronized native int wndSetFrameInsets(int var0, int var1, int var2, int var3);

    static synchronized native void wndSetIcon(Ptr var0, Ptr var1);

    static synchronized native void wndSetResizable(Ptr var0, boolean var1, int var2, int var3, int var4, int var5);

    static synchronized native void wndSetTitle(Ptr var0, String var1);

    static synchronized native void wndSetVisible(Ptr var0, boolean var1);

    static synchronized native void wndToBack(Ptr var0);

    static synchronized native void wndToFront(Ptr var0);

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Toolkit() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        lightweightPeer = new 1();
        windowPeer = new 2();
        System.loadLibrary("awt");
        flags = Toolkit.tlkProperties();
        if ((flags & 8) == 0) {
            if (!Toolkit.tlkInit(System.getProperty("awt.display"))) {
                throw new AWTError("native layer initialization failed");
            }
            Toolkit.initToolkit();
            return;
        }
        collectorThread = new NativeCollector();
        collectorThread.start();
        try {
            Class clazz = class$Ljava$awt$Toolkit != null ? class$Ljava$awt$Toolkit : (class$Ljava$awt$Toolkit = Toolkit.class$("java.awt.Toolkit"));
            synchronized (clazz) {
                while (true) {
                    if (singleton != null) {
                        return;
                    }
                    (class$Ljava$awt$Toolkit != null ? class$Ljava$awt$Toolkit : Toolkit.class$("java.awt.Toolkit")).wait();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

