/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import kaffe.util.UTF8;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }

    public final boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final char readChar() throws IOException {
        int n = this.read() << 8;
        if ((n |= this.read()) == -1) {
            throw new EOFException();
        }
        return (char)n;
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read(byArray, n + n3, n2 - n3);
            if (n4 == -1) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    public final int readInt() throws IOException {
        int n = this.read() << 24;
        n |= this.read() << 16;
        n |= this.read() << 8;
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return n | n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[1];
        boolean bl = false;
        while (true) {
            if (this.read(byArray, 0, 1) != 1) {
                bl = true;
                break;
            }
            char c = (char)(byArray[0] & 0xFF);
            if (c == '\n') break;
            if (c == '\r') {
                super.mark(1);
                if (this.read(byArray, 0, 1) != 1 || byArray[0] == 10) break;
                try {
                    super.reset();
                }
                catch (IOException iOException) {
                }
                break;
            }
            stringBuffer.append(c);
        }
        if (bl && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public final long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public final short readShort() throws IOException {
        int n = this.read() << 8;
        if ((n |= this.read()) == -1) {
            throw new EOFException();
        }
        return (short)n;
    }

    public final String readUTF() throws IOException {
        return UTF8.decode(this, this.readUnsignedShort());
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        return UTF8.decode(dataInput, dataInput.readUnsignedShort());
    }

    public final int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public final int skipBytes(int n) throws IOException {
        int n2 = n;
        while (n2 > 0) {
            n2 -= (int)this.in.skip(n2);
        }
        return n;
    }

    public DataInputStream(InputStream inputStream) {
        super(inputStream);
    }
}

