/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class PrintStream
extends FilterOutputStream {
    private static final char[] newline = System.getProperty("line.separator").toCharArray();
    private final boolean autoFlush;
    private boolean error = false;

    public boolean checkError() {
        this.flush();
        return this.error;
    }

    protected void setError() {
        this.error = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            this.flush();
            this.out.close();
            return;
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush() {
        try {
            this.out.flush();
            return;
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void print(Object object) {
        this.print(String.valueOf(object).getBytes());
    }

    public void print(String string) {
        this.print((string != null ? string : "null").getBytes());
    }

    public void print(boolean bl) {
        this.print(String.valueOf(bl).getBytes());
    }

    public void print(char c) {
        this.print(String.valueOf(c).getBytes());
    }

    public void print(char[] cArray) {
        this.print(String.valueOf(cArray).getBytes());
    }

    public void print(double d) {
        this.print(String.valueOf(d).getBytes());
    }

    public void print(float f) {
        this.print(String.valueOf(f).getBytes());
    }

    public void print(int n) {
        this.print(String.valueOf(n).getBytes());
    }

    public void print(long l) {
        this.print(String.valueOf(l).getBytes());
    }

    public void println() {
        this.print(newline);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void println(Object object) {
        this.print(object);
        this.println();
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public void println(boolean bl) {
        this.print(bl);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(char[] cArray) {
        this.print(cArray);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(int n) {
        this.print(n);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(byte[] byArray, int n, int n2) {
        try {
            this.out.write(byArray, n, n2);
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.error = true;
        }
        if (this.autoFlush) {
            this.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(int n) {
        try {
            this.out.write(n);
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.error = true;
        }
        if (n == 10 && this.autoFlush) {
            this.flush();
        }
    }

    private void print(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public PrintStream(OutputStream outputStream) {
        super(outputStream);
        this.autoFlush = false;
        if (outputStream == null) {
            throw new NullPointerException();
        }
    }

    public PrintStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.autoFlush = bl;
        if (outputStream == null) {
            throw new NullPointerException();
        }
    }
}

