/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class URLClassLoader
extends SecureClassLoader {
    private static /* synthetic */ Class class$Ljava$net$URLClassLoader;
    private final Vector urls;
    private final URLStreamHandlerFactory factory;
    private final HashMap handlers = new HashMap();
    private final HashMap jarFiles = new HashMap();

    protected void addURL(URL uRL) {
        this.urls.addElement(uRL);
    }

    public URL[] getURLs() {
        return (URL[])this.urls.toArray(new URL[this.urls.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findClass(String string) throws ClassNotFoundException {
        URL uRL = this.findResource(string.replace('.', '/') + ".class");
        if (uRL == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            InputStream inputStream = uRL.openStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while (true) {
                int n;
                if ((n = inputStream.read(byArray)) == -1) {
                    inputStream.close();
                    byArray = byteArrayOutputStream.toByteArray();
                    return this.defineClass(string, byArray, 0, byArray.length, (CodeSource)null);
                }
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string + ": " + iOException);
        }
    }

    private URLStreamHandler getHandler(URL uRL) {
        if (this.factory == null) {
            return null;
        }
        String string = uRL.getProtocol();
        URLStreamHandler uRLStreamHandler = (URLStreamHandler)this.handlers.get(string);
        if (uRLStreamHandler == null) {
            uRLStreamHandler = this.factory.createURLStreamHandler(string);
            this.handlers.put(string, uRLStreamHandler);
        }
        return uRLStreamHandler;
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        return super.definePackage(string, manifest.getAttributes(string).getValue(Attributes.Name.SPECIFICATION_TITLE), manifest.getAttributes(string).getValue(Attributes.Name.SPECIFICATION_VERSION), manifest.getAttributes(string).getValue(Attributes.Name.SPECIFICATION_VENDOR), manifest.getAttributes(string).getValue(Attributes.Name.IMPLEMENTATION_TITLE), manifest.getAttributes(string).getValue(Attributes.Name.IMPLEMENTATION_VERSION), manifest.getAttributes(string).getValue(Attributes.Name.IMPLEMENTATION_VENDOR), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL findResource(String string) {
        try {
            return (URL)this.findResources(string).nextElement();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration findResources(String string) throws IOException {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.urls.size()) {
            block8: {
                URL uRL = (URL)this.urls.elementAt(n);
                try {
                    Object object;
                    if (uRL.getFile().endsWith("/")) {
                        uRL = new URL(uRL, string, this.getHandler(uRL));
                    } else {
                        object = this.getJar(uRL);
                        if (object == null) break block8;
                        uRL = new URL("jar:file:" + object + "!/" + string);
                    }
                    object = uRL.openConnection();
                    vector.addElement(uRL);
                    try {
                        object.getClass().getMethod("disconnect", null).invoke(object, new Object[0]);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (IOException iOException) {
                }
            }
            ++n;
        }
        return vector.elements();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getJar(URL uRL) {
        File file = (File)this.jarFiles.get(uRL);
        if (file != null) {
            return file;
        }
        try {
            file = File.createTempFile("jar", null);
            file.deleteOnExit();
            InputStream inputStream = uRL.openStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while (true) {
                int n;
                if ((n = inputStream.read(byArray)) == -1) {
                    inputStream.close();
                    fileOutputStream.close();
                    this.jarFiles.put(uRL, file);
                    return file;
                }
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        return super.getPermissions(codeSource);
    }

    public static URLClassLoader newInstance(URL[] uRLArray, ClassLoader classLoader) {
        return new URLClassLoader(uRLArray, classLoader);
    }

    public static URLClassLoader newInstance(URL[] uRLArray) {
        return new URLClassLoader(uRLArray);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        this(uRLArray, classLoader, null);
    }

    public URLClassLoader(URL[] uRLArray) {
        this(uRLArray, (class$Ljava$net$URLClassLoader != null ? class$Ljava$net$URLClassLoader : (class$Ljava$net$URLClassLoader = URLClassLoader.class$("java.net.URLClassLoader"))).getClassLoader(), null);
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(classLoader);
        this.urls = new Vector();
        this.factory = uRLStreamHandlerFactory;
        int n = 0;
        while (n < uRLArray.length) {
            this.addURL(uRLArray[n]);
            ++n;
        }
    }
}

