/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractListIterator;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected int modCount;

    public boolean add(Object object) {
        this.add(this.size(), object);
        return true;
    }

    public abstract Object get(int var1);

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            Object object2 = listIterator.next();
            boolean bl = object == null ? object2 == null : object.equals(object2);
            if (bl) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        ListIterator listIterator = this.listIterator(this.size());
        int n = this.size() - 1;
        while (listIterator.hasPrevious()) {
            Object object2 = listIterator.previous();
            boolean bl = object == null ? object2 == null : object.equals(object2);
            if (bl) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    public boolean addAll(int n, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(n++, iterator.next());
        }
        return collection.size() != 0;
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        return new AbstractListIterator(this, n);
    }

    public List subList(int n, int n2) {
        if (n < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        AbstractList abstractList = this;
        if (abstractList == null) {
            throw null;
        }
        return new AbstractList(abstractList, n, n2){
            private final /* synthetic */ AbstractList this$0;
            private final /* synthetic */ int val$fromIndex;
            private final /* synthetic */ int val$toIndex;
            private final AbstractList list;
            private int modCount;
            private final int off;
            private int len;

            public int size() {
                return this.len;
            }

            public Object get(int n) {
                if (n < 0 || n >= this.len) {
                    throw new IndexOutOfBoundsException();
                }
                return this.list.get(this.off + n);
            }

            public Object set(int n, Object object) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (n < 0 || n >= this.len) {
                    throw new IndexOutOfBoundsException();
                }
                return this.list.set(this.off + n, object);
            }

            public void add(int n, Object object) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (n < 0 || n > this.len) {
                    throw new IndexOutOfBoundsException();
                }
                this.list.add(this.off + n, object);
                this.modCount = ((AbstractList)this).modCount;
                ++this.len;
            }

            public Object remove(int n) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (n < 0 || n >= this.len) {
                    throw new IndexOutOfBoundsException();
                }
                Object object = this.list.remove(this.off + n);
                this.modCount = ((AbstractList)this).modCount;
                --this.len;
                return object;
            }

            public int indexOf(Object object) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                ListIterator listIterator = this.list.listIterator(this.off);
                int n = 0;
                while (n < this.len && listIterator.hasNext()) {
                    Object object2 = listIterator.next();
                    boolean bl = object == null ? object2 == null : object.equals(object2);
                    if (bl) {
                        return n;
                    }
                    ++n;
                }
                return -1;
            }

            public int lastIndexOf(Object object) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                ListIterator listIterator = this.listIterator(this.off + this.len);
                int n = this.len - 1;
                while (listIterator.hasPrevious()) {
                    Object object2 = listIterator.previous();
                    boolean bl = object == null ? object2 == null : object.equals(object2);
                    if (bl) {
                        return n;
                    }
                    --n;
                }
                return -1;
            }

            protected void removeRange(int n, int n2) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (n < 0 || n2 > this.len) {
                    throw new IndexOutOfBoundsException();
                }
                this.list.removeRange(this.off + n, this.off + n2);
                this.modCount = ((AbstractList)this).modCount;
                this.len -= n2 - n;
            }
            {
                this.val$fromIndex = n;
                this.val$toIndex = n2;
                this.this$0 = abstractList;
                this.list = this;
                this.modCount = ((AbstractList)this).modCount;
                this.off = this.val$fromIndex;
                this.len = this.val$toIndex - this.val$fromIndex;
                this.constructor$0(abstractList);
            }

            public void constructor$0(AbstractList abstractList) {
            }
        };
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext()) {
            Object object2 = listIterator.next();
            Object object3 = listIterator2.next();
            if (object2 == null ? object3 == null : object2.equals(object3)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    protected void removeRange(int n, int n2) {
        ListIterator listIterator = this.listIterator(n);
        while (n < n2 && listIterator.hasNext()) {
            listIterator.remove();
            ++n;
        }
    }

    protected AbstractList() {
    }
}

