/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Arrays {
    static final Comparator DEFAULT_COMPARATOR = new DefCmp();

    public static List asList(Object[] objectArray) {
        return new ArrayList(objectArray);
    }

    public static int binarySearch(byte[] byArray, byte by) {
        int n = 0;
        int n2 = byArray.length;
        while (n2 != 0) {
            int n3 = n + (n2 >> 1);
            if (by == byArray[n3]) {
                return n3;
            }
            if (by > byArray[n3]) {
                n = n3 + 1;
                --n2;
            }
            n2 >>= 1;
        }
        return ~n;
    }

    public static int binarySearch(char[] cArray, char c) {
        int n = 0;
        int n2 = cArray.length;
        while (n2 != 0) {
            int n3 = n + (n2 >> 1);
            if (c == cArray[n3]) {
                return n3;
            }
            if (c > cArray[n3]) {
                n = n3 + 1;
                --n2;
            }
            n2 >>= 1;
        }
        return ~n;
    }

    public static int binarySearch(double[] dArray, double d) {
        long l = Double.doubleToLongBits(d);
        int n = 0;
        int n2 = dArray.length;
        while (n2 != 0) {
            int n3 = n + (n2 >> 1);
            long l2 = Double.doubleToLongBits(dArray[n3]);
            if (l == l2) {
                return n3;
            }
            if (l > l2) {
                n = n3 + 1;
                --n2;
            }
            n2 >>= 1;
        }
        return ~n;
    }

    public static int binarySearch(float[] fArray, float f) {
        int n = Float.floatToIntBits(f);
        int n2 = 0;
        int n3 = fArray.length;
        while (n3 != 0) {
            int n4 = n2 + (n3 >> 1);
            int n5 = Float.floatToIntBits(fArray[n4]);
            if (n == n5) {
                return n4;
            }
            if (n > n5) {
                n2 = n4 + 1;
                --n3;
            }
            n3 >>= 1;
        }
        return ~n2;
    }

    public static int binarySearch(int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length;
        while (n3 != 0) {
            int n4 = n2 + (n3 >> 1);
            if (n == nArray[n4]) {
                return n4;
            }
            if (n > nArray[n4]) {
                n2 = n4 + 1;
                --n3;
            }
            n3 >>= 1;
        }
        return ~n2;
    }

    public static int binarySearch(short[] sArray, short s) {
        int n = 0;
        int n2 = sArray.length;
        while (n2 != 0) {
            int n3 = n + (n2 >> 1);
            if (s == sArray[n3]) {
                return n3;
            }
            if (s > sArray[n3]) {
                n = n3 + 1;
                --n2;
            }
            n2 >>= 1;
        }
        return ~n;
    }

    public static int binarySearch(long[] lArray, long l) {
        int n = 0;
        int n2 = lArray.length;
        while (n2 != 0) {
            int n3 = n + (n2 >> 1);
            if (l == lArray[n3]) {
                return n3;
            }
            if (l > lArray[n3]) {
                n = n3 + 1;
                --n2;
            }
            n2 >>= 1;
        }
        return ~n;
    }

    public static int binarySearch(Object[] objectArray, Object object) {
        return Arrays.binarySearch(objectArray, object, DEFAULT_COMPARATOR);
    }

    public static int binarySearch(Object[] objectArray, Object object, Comparator comparator) {
        int n = 0;
        int n2 = objectArray.length;
        while (n2 != 0) {
            int n3 = n + (n2 >> 1);
            int n4 = comparator.compare(object, objectArray[n3]);
            if (n4 == 0) {
                return n3;
            }
            if (n4 > 0) {
                n = n3 + 1;
                --n2;
            }
            n2 >>= 1;
        }
        return ~n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(boolean[] blArray, boolean[] blArray2) {
        try {
            if (blArray.length != blArray2.length) {
                return false;
            }
            int n = blArray.length;
            do {
                if (n-- > 0) continue;
                return true;
            } while (blArray[n] == blArray2[n]);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (blArray == blArray2) return true;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(byte[] byArray, byte[] byArray2) {
        try {
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n = byArray.length;
            do {
                if (n-- > 0) continue;
                return true;
            } while (byArray[n] == byArray2[n]);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (byArray == byArray2) return true;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(char[] cArray, char[] cArray2) {
        try {
            if (cArray.length != cArray2.length) {
                return false;
            }
            int n = cArray.length;
            do {
                if (n-- > 0) continue;
                return true;
            } while (cArray[n] == cArray2[n]);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (cArray == cArray2) return true;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(double[] dArray, double[] dArray2) {
        try {
            if (dArray.length != dArray2.length) {
                return false;
            }
            int n = dArray.length;
            do {
                if (n-- > 0) continue;
                return true;
            } while (dArray[n] == dArray2[n]);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (dArray == dArray2) return true;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(float[] fArray, float[] fArray2) {
        try {
            if (fArray.length != fArray2.length) {
                return false;
            }
            int n = fArray.length;
            do {
                if (n-- > 0) continue;
                return true;
            } while (fArray[n] == fArray2[n]);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (fArray == fArray2) return true;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(int[] nArray, int[] nArray2) {
        try {
            if (nArray.length != nArray2.length) {
                return false;
            }
            int n = nArray.length;
            do {
                if (n-- > 0) continue;
                return true;
            } while (nArray[n] == nArray2[n]);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (nArray == nArray2) return true;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(short[] sArray, short[] sArray2) {
        try {
            if (sArray.length != sArray2.length) {
                return false;
            }
            int n = sArray.length;
            do {
                if (n-- > 0) continue;
                return true;
            } while (sArray[n] == sArray2[n]);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (sArray == sArray2) return true;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(long[] lArray, long[] lArray2) {
        try {
            if (lArray.length != lArray2.length) {
                return false;
            }
            int n = lArray.length;
            do {
                if (n-- > 0) continue;
                return true;
            } while (lArray[n] == lArray2[n]);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (lArray == lArray2) return true;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        try {
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            int n = objectArray.length;
            do {
                if (n-- > 0) continue;
                return true;
            } while (objectArray[n].equals(objectArray2[n]));
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (objectArray == objectArray2) return true;
            return false;
        }
    }

    public static void fill(boolean[] blArray, boolean bl) {
        Arrays.fill(blArray, 0, blArray.length, bl);
    }

    public static void fill(boolean[] blArray, int n, int n2, boolean bl) {
        int n3 = n2;
        while (n3-- > n) {
            blArray[n3] = bl;
        }
    }

    public static void fill(byte[] byArray, byte by) {
        Arrays.fill(byArray, 0, byArray.length, by);
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        int n3 = n2;
        while (n3-- > n) {
            byArray[n3] = by;
        }
    }

    public static void fill(char[] cArray, char c) {
        Arrays.fill(cArray, 0, cArray.length, c);
    }

    public static void fill(char[] cArray, int n, int n2, char c) {
        int n3 = n2;
        while (n3-- > n) {
            cArray[n3] = c;
        }
    }

    public static void fill(double[] dArray, double d) {
        Arrays.fill(dArray, 0, dArray.length, d);
    }

    public static void fill(double[] dArray, int n, int n2, double d) {
        int n3 = n2;
        while (n3-- > n) {
            dArray[n3] = d;
        }
    }

    public static void fill(float[] fArray, float f) {
        Arrays.fill(fArray, 0, fArray.length, f);
    }

    public static void fill(float[] fArray, int n, int n2, float f) {
        int n3 = n2;
        while (n3-- > n) {
            fArray[n3] = f;
        }
    }

    public static void fill(int[] nArray, int n) {
        Arrays.fill(nArray, 0, nArray.length, n);
    }

    public static void fill(int[] nArray, int n, int n2, int n3) {
        int n4 = n2;
        while (n4-- > n) {
            nArray[n4] = n3;
        }
    }

    public static void fill(short[] sArray, short s) {
        Arrays.fill(sArray, 0, sArray.length, s);
    }

    public static void fill(short[] sArray, int n, int n2, short s) {
        int n3 = n2;
        while (n3-- > n) {
            sArray[n3] = s;
        }
    }

    public static void fill(long[] lArray, long l) {
        Arrays.fill(lArray, 0, lArray.length, l);
    }

    public static void fill(long[] lArray, int n, int n2, long l) {
        int n3 = n2;
        while (n3-- > n) {
            lArray[n3] = l;
        }
    }

    public static void fill(Object[] objectArray, Object object) {
        Arrays.fill(objectArray, 0, objectArray.length, object);
    }

    public static void fill(Object[] objectArray, int n, int n2, Object object) {
        int n3 = n2;
        while (n3-- > n) {
            objectArray[n3] = object;
        }
    }

    public static void sort(byte[] byArray) {
        Arrays.sort(byArray, 0, byArray.length);
    }

    public static void sort(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 > byArray.length || n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sortByte(byArray, n, n2);
    }

    public static void sort(char[] cArray) {
        Arrays.sort(cArray, 0, cArray.length);
    }

    public static void sort(char[] cArray, int n, int n2) {
        if (n < 0 || n2 > cArray.length || n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sortChar(cArray, n, n2);
    }

    public static void sort(double[] dArray) {
        Arrays.sort(dArray, 0, dArray.length);
    }

    public static void sort(double[] dArray, int n, int n2) {
        if (n < 0 || n2 > dArray.length || n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sortDouble(dArray, n, n2);
    }

    public static void sort(float[] fArray) {
        Arrays.sort(fArray, 0, fArray.length);
    }

    public static void sort(float[] fArray, int n, int n2) {
        if (n < 0 || n2 > fArray.length || n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sortFloat(fArray, n, n2);
    }

    public static void sort(int[] nArray) {
        Arrays.sort(nArray, 0, nArray.length);
    }

    public static void sort(int[] nArray, int n, int n2) {
        if (n < 0 || n2 > nArray.length || n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sortInt(nArray, n, n2);
    }

    public static void sort(short[] sArray) {
        Arrays.sort(sArray, 0, sArray.length);
    }

    public static void sort(short[] sArray, int n, int n2) {
        if (n < 0 || n2 > sArray.length || n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sortShort(sArray, n, n2);
    }

    public static void sort(long[] lArray) {
        Arrays.sort(lArray, 0, lArray.length);
    }

    public static void sort(long[] lArray, int n, int n2) {
        if (n < 0 || n2 > lArray.length || n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sortLong(lArray, n, n2);
    }

    public static void sort(Object[] objectArray) {
        Arrays.sort(objectArray, 0, objectArray.length, DEFAULT_COMPARATOR);
    }

    public static void sort(Object[] objectArray, Comparator comparator) {
        Arrays.sort(objectArray, 0, objectArray.length, comparator);
    }

    public static void sort(Object[] objectArray, int n, int n2) {
        Arrays.sort(objectArray, n, n2, DEFAULT_COMPARATOR);
    }

    public static void sort(Object[] objectArray, int n, int n2, Comparator comparator) {
        if (n < 0 || n2 > objectArray.length || n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sortObject(objectArray, n, n2, comparator);
    }

    private static native void sortByte(byte[] var0, int var1, int var2);

    private static native void sortChar(char[] var0, int var1, int var2);

    private static native void sortDouble(double[] var0, int var1, int var2);

    private static native void sortFloat(float[] var0, int var1, int var2);

    private static native void sortInt(int[] var0, int var1, int var2);

    private static native void sortShort(short[] var0, int var1, int var2);

    private static native void sortLong(long[] var0, int var1, int var2);

    private static native void sortObject(Object[] var0, int var1, int var2, Comparator var3);

    private Arrays() {
    }

    private static class DefCmp
    implements Serializable,
    Comparator {
        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }

        DefCmp() {
        }
    }
}

