/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractMapEntry;
import java.util.AbstractMapEntrySet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOADFACTOR = 0.75f;
    float loadFactor;
    Entry[] table;
    private int modCount;
    private int size;

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsValue(Object object) {
        int n = 0;
        while (n < this.table.length) {
            Entry entry = this.table[n];
            while (entry != null) {
                boolean bl = object == null ? entry.value == null : object.equals(entry.value);
                if (bl) {
                    return true;
                }
                entry = entry.access$0();
            }
            ++n;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.find(object) != null;
    }

    public Object get(Object object) {
        Entry entry = this.find(object);
        return entry == null ? null : entry.value;
    }

    public Object put(Object object, Object object2) {
        int n = HashMap.bucket(object, this.table.length);
        Entry entry = this.find(object, n);
        if (entry != null) {
            Object object3 = entry.value;
            entry.value = object2;
            return object3;
        }
        if ((float)this.size / (float)this.table.length >= this.loadFactor) {
            this.rehash();
            n = HashMap.bucket(object, this.table.length);
        }
        HashMap hashMap = this;
        if (hashMap == null) {
            throw null;
        }
        entry = hashMap.new Entry(object, object2);
        entry.access$1(this.table[n]);
        this.table[n] = entry;
        ++this.modCount;
        ++this.size;
        return null;
    }

    public Object remove(Object object) {
        int n = HashMap.bucket(object, this.table.length);
        Entry entry = this.table[n];
        if (entry == null) {
            return null;
        }
        boolean bl = object == null ? entry.key == null : object.equals(entry.key);
        if (bl) {
            Object object2 = entry.value;
            this.table[n] = entry.access$0();
            ++this.modCount;
            --this.size;
            return object2;
        }
        Entry entry2 = entry;
        while (entry2.access$0() != null) {
            boolean bl2 = object == null ? entry2.access$0().key == null : object.equals(entry2.access$0().key);
            if (bl2) {
                Object object3 = entry2.access$0().value;
                entry2.access$1(entry2.access$0().access$0());
                ++this.modCount;
                --this.size;
                return object3;
            }
            entry2 = entry2.access$0();
        }
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.table = new Entry[11];
        ++this.modCount;
        this.size = 0;
    }

    public Object clone() {
        HashMap hashMap = (HashMap)super.clone();
        hashMap.table = new Entry[this.table.length];
        int n = 0;
        while (n < this.table.length) {
            Entry entry = this.table[n];
            if (entry != null) {
                Entry entry2;
                HashMap hashMap2 = this;
                if (hashMap2 == null) {
                    throw null;
                }
                hashMap.table[n] = entry2 = hashMap2.new Entry(entry.key, entry.value);
                Entry entry3 = entry.access$0();
                while (entry3 != null) {
                    HashMap hashMap3 = this;
                    if (hashMap3 == null) {
                        throw null;
                    }
                    entry2.access$1(hashMap3.new Entry(entry3.key, entry3.value));
                    entry2 = entry2.access$0();
                    entry3 = entry3.access$0();
                }
            }
            ++n;
        }
        return hashMap;
    }

    public Set entrySet() {
        HashMap hashMap = this;
        if (hashMap == null) {
            throw null;
        }
        return new AbstractMapEntrySet(hashMap, this){
            private final /* synthetic */ HashMap this$0;

            public Iterator iterator() {
                HashMap hashMap = this.this$0;
                if (hashMap == null) {
                    throw null;
                }
                return hashMap.new EntryIterator();
            }

            protected Map.Entry find(Map.Entry entry) {
                Entry entry2 = this.this$0.access$0(entry.getKey());
                return entry.equals(entry2) ? entry2 : null;
            }
            {
                this.this$0 = hashMap;
                this.constructor$0(hashMap, map);
            }

            public void constructor$0(HashMap hashMap, Map map) {
            }
        };
    }

    void rehash() {
        Entry[] entryArray = new Entry[this.table.length * 2];
        int n = 0;
        while (n < this.table.length) {
            Entry entry = this.table[n];
            while (entry != null) {
                Entry entry2 = entry.access$0();
                int n2 = HashMap.bucket(entry.key, entryArray.length);
                entry.access$1(entryArray[n2]);
                entryArray[n2] = entry;
                entry = entry2;
            }
            ++n;
        }
        this.table = entryArray;
    }

    private Entry find(Object object) {
        return this.find(object, HashMap.bucket(object, this.table.length));
    }

    private Entry find(Object object, int n) {
        Entry entry = this.table[n];
        while (entry != null) {
            boolean bl = object == null ? entry.key == null : object.equals(entry.key);
            if (bl) {
                return entry;
            }
            entry = entry.access$0();
        }
        return null;
    }

    private static final int bucket(Object object, int n) {
        int n2;
        int n3 = n2 = object == null ? 0 : object.hashCode();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    /* synthetic */ Entry access$0(Object object) {
        return this.find(object);
    }

    /* synthetic */ int access$1() {
        return this.modCount;
    }

    public HashMap() {
        this(11, 0.75f);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap(int n, float f) {
        if (n < 0 || f <= 0.0f) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n = 1;
        }
        this.table = new Entry[n];
        this.loadFactor = f;
    }

    public HashMap(Map map) {
        int n = map.size() * 2;
        if (n < 11) {
            n = 11;
        }
        this.table = new Entry[n];
        this.loadFactor = 0.75f;
        this.putAll(map);
    }

    private class Entry
    extends AbstractMapEntry {
        private Entry next = null;

        public void changeValue(Object object) {
            HashMap.this.put(this.key, object);
        }

        /* synthetic */ Entry access$0() {
            return this.next;
        }

        /* synthetic */ void access$1(Entry entry) {
            this.next = entry;
        }

        Entry(Object object, Object object2) {
            super(object, object2);
        }
    }

    private class EntryIterator
    implements Iterator {
        private int bucket;
        private int modCount;
        private Entry next;
        private Entry prev;

        public boolean hasNext() {
            if (this.modCount != HashMap.this.access$1()) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        public Object next() {
            if (this.modCount != HashMap.this.access$1()) {
                throw new ConcurrentModificationException();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.next;
            this.next = this.next.access$0();
            if (this.next == null) {
                this.nextBucket();
            }
            return this.prev;
        }

        public void remove() {
            if (this.modCount != HashMap.this.access$1()) {
                throw new ConcurrentModificationException();
            }
            if (this.prev == null) {
                throw new IllegalStateException();
            }
            HashMap.this.remove(this.prev.key);
            ++this.modCount;
            this.prev = null;
        }

        private void nextBucket() {
            while (++this.bucket < HashMap.this.table.length && HashMap.this.table[this.bucket] == null) {
            }
            if (this.bucket < HashMap.this.table.length) {
                this.next = HashMap.this.table[this.bucket];
            }
        }

        EntryIterator() {
            this.modCount = HashMap.this.access$1();
            this.bucket = -1;
            this.nextBucket();
        }
    }
}

