/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Vector
extends AbstractList
implements List,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2767605614048989439L;
    protected int capacityIncrement;
    protected int elementCount;
    protected Object[] elementData;

    public synchronized void addElement(Object object) {
        if (this.elementCount == this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount++] = object;
    }

    public int capacity() {
        return this.elementData.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object clone() {
        try {
            Object object;
            Vector vector = (Vector)super.clone();
            try {
                object = this.elementData.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException.getMessage());
            }
            vector.elementData = (Object[])object;
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        this.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        }
        this.copyInto(objectArray);
        int n = objectArray.length;
        while (n-- > this.elementCount) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n) + " >= " + this.elementCount);
        }
        return this.elementData[n];
    }

    public synchronized Enumeration elements() {
        Vector vector = this;
        if (vector == null) {
            throw null;
        }
        return new Enumeration(vector){
            private final /* synthetic */ Vector this$0;
            int index;

            public boolean hasMoreElements() {
                return this.index < this.this$0.elementCount;
            }

            public Object nextElement() {
                if (this.index >= this.this$0.elementCount) {
                    throw new NoSuchElementException();
                }
                return this.this$0.elementData[this.index++];
            }
            {
                this.this$0 = vector;
                this.index = 0;
                this.constructor$0(vector);
            }

            public void constructor$0(Vector vector) {
            }
        };
    }

    public synchronized void ensureCapacity(int n) {
        if (this.elementData.length < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[n];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public synchronized Object firstElement() {
        if (this.elementCount <= 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public Object get(int n) {
        return this.elementAt(n);
    }

    private void increaseCapacity() {
        int n = this.elementData.length;
        n = this.capacityIncrement > 0 ? (n += this.capacityIncrement) : (n == 0 ? 10 : (n *= 2));
        Object[] objectArray = this.elementData;
        this.elementData = new Object[n];
        System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int n) {
        int n2 = n;
        while (n2 < this.elementCount) {
            Object object2 = this.elementData[n2];
            if (object == object2 || object.equals(object2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized void insertElementAt(Object object, int n) {
        if (this.elementCount == this.elementData.length) {
            this.increaseCapacity();
        }
        if (n > this.elementCount || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        }
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.size() - 1);
    }

    public synchronized int lastIndexOf(Object object, int n) {
        int n2 = n;
        while (n2 >= 0) {
            Object object2 = this.elementData[n2];
            if (object == object2 || object.equals(object2)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public synchronized Object remove(int n) {
        Object object = this.elementAt(n);
        this.removeElementAt(n);
        return object;
    }

    public synchronized void removeAllElements() {
        int n = this.elementCount - 1;
        while (n >= 0) {
            this.elementData[n] = null;
            --n;
        }
        this.elementCount = 0;
    }

    public synchronized boolean removeElement(Object object) {
        if (this.contains(object)) {
            this.removeElementAt(this.indexOf(object));
            return true;
        }
        return false;
    }

    public synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - n - 1);
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public synchronized void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.elementData[n] = object;
    }

    public synchronized void setSize(int n) {
        this.ensureCapacity(n);
        this.elementCount = n;
    }

    public int size() {
        return this.elementCount;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.elementCount) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elementData[n].toString());
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public synchronized void trimToSize() {
        if (this.elementCount != this.elementData.length) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public Vector() {
        this(10, 0);
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector(int n, int n2) {
        this.elementData = new Object[n];
        this.elementCount = 0;
        this.capacityIncrement = n2;
    }

    public Vector(Collection collection) {
        this(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addElement(iterator.next());
        }
    }
}

