//:  BeOSButtonUI.java

package com.be.swing.plaf.beos;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.border.*;
import javax.swing.plaf.basic.*;

/**
 * BeOS Look and Feel ButtonUI delegate.
 * 
 * @author  Michael Heuer
 * @version $Id: BeOSButtonUI.java,v 1.3 1999/11/08 21:07:11 heuermh Exp $
 */
public class BeOSButtonUI extends BasicButtonUI {

	private static final BeOSButtonUI buttonUI = new BeOSButtonUI();

	private boolean defaultsInitialized;
	
	protected Color selectColor;
	protected Color selectTextColor;
	protected Color disabledTextColor;

	public static ComponentUI createUI(JComponent c) {
		return buttonUI;
	}

	public void installDefaults(AbstractButton b) {
		super.installDefaults(b);
		
		if (!defaultsInitialized) {

			selectColor = UIManager.getColor(getPropertyPrefix() + "select");
			selectTextColor = UIManager.getColor(getPropertyPrefix() + "selectText");
			disabledTextColor = UIManager.getColor(getPropertyPrefix() + "disabledText");
			
			defaultsInitialized = true;
		}

		b.setOpaque(false);
	}

	public void uninstallDefaults(AbstractButton b) {
		super.uninstallDefaults(b);
		defaultsInitialized = false;
	}

	protected BasicButtonListener createButtonListener(AbstractButton b) {
		return new BeOSButtonListener(b);
	}

	protected Color getSelectColor() {
		return selectColor;
	}
	protected Color getSelectTextColor() {
		return selectTextColor;
	}
	protected Color getDisabledTextColor() {
		return disabledTextColor;
	}

	protected void paintButtonPressed(Graphics g, AbstractButton b) {

		if (b.isContentAreaFilled() ) {
			Dimension size = b.getSize();
                        
			g.setColor(getSelectColor());

			if ( ((JButton) b).isDefaultCapable() ) {
		        g.fillRect(5, 5, size.width - 10, size.height - 10);
        
			} else {
		        g.fillRect(1, 1, size.width - 1, size.height - 1);
        
			}
		}
	}

	protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
	}

	protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {

		AbstractButton b = (AbstractButton) c;
		ButtonModel model = b.getModel();
		FontMetrics fm = g.getFontMetrics();
		
		final int noMnemonic = -1;
		
		if (model.isEnabled()) {
			if (model.isPressed() && model.isArmed()) {
        
		        g.setColor(getSelectTextColor());
		        BasicGraphicsUtils.drawString(g, text, noMnemonic, textRect.x, textRect.y + fm.getAscent());
		        
			} else {
        
		        g.setColor(b.getForeground());
		        BasicGraphicsUtils.drawString(g, text, noMnemonic, textRect.x, textRect.y + fm.getAscent());    
			}

		} else {

			g.setColor(getDisabledTextColor());
			BasicGraphicsUtils.drawString(g, text, noMnemonic, textRect.x, textRect.y + fm.getAscent());

		}
	}

	public void paint(Graphics g, JComponent c) {

		AbstractButton b = (AbstractButton) c;
		if (b.isContentAreaFilled()) {
		
			Dimension size = b.getSize();
			g.setColor(b.getBackground());
			
			if ( ((JButton) b).isDefaultCapable() ) {
		        g.fillRect(5, 5, size.width - 10, size.height - 10);
		
			} else {
		        g.fillRect(1, 1, size.width - 1, size.height - 1);
		    
			}
		} 

		super.paint(g,c);
	}


	class BeOSButtonListener extends BasicButtonListener {
		public BeOSButtonListener(AbstractButton b) {
			super(b);
		}

		// see bug #4146858
		public void focusGained(FocusEvent e) {
			Component c = (Component) e.getSource();
			c.repaint();
		}
	}
}