//:  BeOSLabelUI.java

package com.be.swing.plaf.beos;

import java.awt.*;

import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * BeOS Look and Feel LabelUI delegate.
 * Only necessary because the Basic LabelUI component
 * doesn't paint disabled text correctly.  
 *
 * @author  Michael Heuer
 * @version $Id: BeOSLabelUI.java,v 1.3 1999/11/08 21:07:13 heuermh Exp $
 */
public class BeOSLabelUI extends BasicLabelUI {

	protected static BeOSLabelUI labelUI = new BeOSLabelUI();

	private boolean defaultsInitialized;

	protected Color disabledTextColor;
	protected static final String propertyPrefix = "Label" + ".";
	
	public static ComponentUI createUI(JComponent c) {
		return labelUI;
	}

	public void installDefaults(JLabel l) {
		super.installDefaults(l);

		if (!defaultsInitialized) {
        
			disabledTextColor = UIManager.getColor(getPropertyPrefix() + "disabledText");
		}
		defaultsInitialized = true;
	}

	protected Color getDisabledTextColor() {
		return disabledTextColor;
	}

	protected String getPropertyPrefix() {
		return propertyPrefix;
	}

	protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
		int noMnemonic = -1;

		g.setColor(l.getForeground());
		BasicGraphicsUtils.drawString(g, s, noMnemonic, textX, textY);
	}
	
	protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
		int noMnemonic = -1;

		g.setColor(getDisabledTextColor());
		BasicGraphicsUtils.drawString(g, s, noMnemonic, textX, textY);
	}
}