//:  BeOSProgressBarUI.java

package com.be.swing.plaf.beos;

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * BeOS Look and Feel ProgressBarUI delegate.
 * 
 * @author  Michael Heuer
 * @version $Id: BeOSProgressBarUI.java,v 1.5 1999/11/10 04:01:20 heuermh Exp $
 */
public class BeOSProgressBarUI extends BasicProgressBarUI {
	private boolean defaultsInitialized = false;
	
	protected Color barMiddleColor;
	protected Color barHighlightColor;
	protected Color barShadowColor;

	public static ComponentUI createUI(JComponent c) {
		return new BeOSProgressBarUI();
	}

	protected void installDefaults() {
		super.installDefaults();
		
		if (!defaultsInitialized) {

			barMiddleColor = UIManager.getColor("ProgressBar.barMiddle");
			barHighlightColor = UIManager.getColor("ProgressBar.barHighlight");
			barShadowColor = UIManager.getColor("ProgressBar.barShadow");
			
			defaultsInitialized = true;
		}
	}
	
	protected Color getBarMiddleColor() {
		return barMiddleColor;
	}
	protected Color getBarHighlightColor() {
		return barHighlightColor;
	}
	protected Color getBarShadowColor() {
		return barShadowColor;
	}
	
	public void paint(Graphics g, JComponent c) {

		/**
		 * Chopped out of BasicProgressBarUI because of
		 * bad design in the basic UI delegates (again).
		 */

		BoundedRangeModel model = progressBar.getModel();

		int barRectX = 0;
		int barRectY = 0;
		int barRectWidth = progressBar.getWidth();
		int barRectHeight = progressBar.getHeight();
		Insets b = progressBar.getInsets(); // area for border
		barRectX += b.left;
		barRectY += b.top;
		barRectWidth -= (b.right + barRectX);
		barRectHeight -= (b.bottom + barRectY);
		
		int current;
		// a cell and its spacing
		int increment = getCellLength() + getCellSpacing();
		// amount of progress to draw
		int amountFull = getAmountFull(b, barRectWidth, barRectHeight);

		g.setColor(progressBar.getForeground());
		if (progressBar.getOrientation() == JProgressBar.HORIZONTAL) {

			// draw the cells
			if (getCellSpacing() == 0 && amountFull > 0) {

				// draw one big Rect because there is no space between cells

				paintProgressBar(g, barRectX, barRectY, barRectX - b.left + amountFull, barRectHeight);                         

			} else { // draw each individual cells
				// the largest number to draw a cell at
				int max = barRectX + amountFull;

				for (current = barRectX;
						current < max;
						current += increment) {

					g.fillRect(current, barRectY, getCellLength(), barRectHeight);
				}
			}
		} else { // VERTICAL
			// draw the cells
			if (getCellSpacing() == 0 && amountFull > 0) {

				// draw one big Rect because there is no space between cells

				paintProgressBar(g, barRectX, barRectHeight - amountFull + b.top, barRectWidth, amountFull);

			} else { // draw each individual cells
				// the smallest number to draw a cell at
				//  that is, the number at the top
				int min = barRectHeight - amountFull;

				for (current = barRectHeight-getCellLength()+getCellSpacing();
						current >= min;
						current -= increment) {
					
					g.fillRect(barRectX, current, barRectWidth, getCellLength());
				}
			}
		}

		// Deal with possible text painting
		if (progressBar.isStringPainted()) {
			paintString(g, barRectX, barRectY, barRectWidth, barRectHeight, amountFull, b);
		}
	}
	
	protected void paintProgressBar(Graphics g, int x, int y, int w, int h) {

		/**
		 * The progress bar blues are unfortunately not derived
		 * from the "BeOS" blue that is used elsewhere in the OS,
		 * so I had to create the extra color properties.
		 */

		g.translate(x,y);

//		g.setColor(progressBar.getForeground());
		g.setColor(getBarMiddleColor());

		g.fillRect( 1, 1, w-2, h-2 );
		
//		g.setColor(progressBar.getForeground().brighter().brighter());
		g.setColor(getBarHighlightColor());

		g.drawLine( 0, 0, 0, h-2 );
		g.drawLine( 0, 0, w-2, 0 );


//		g.setColor(progressBar.getForeground().darker().darker());
		g.setColor(getBarShadowColor());

		g.drawLine( 0, h-1, w-1, h-1 );
		g.drawLine( w-1, h-1, w-1, 0 );

		g.translate(-x,-y);

	}
}