//:  BeOSTextAreaUI.java

package com.be.swing.plaf.beos;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * BeOS Look and Feel TextAreaUI delegate.
 * Only necessary because the Basic TextAreaUI component
 * does not repaint itself on focus changes.  
 *
 * @author  Michael Heuer
 * @version $Id: BeOSTextArea.java,v 1.3 1999/11/08 21:07:15 heuermh Exp $
 */
public class BeOSTextAreaUI extends BasicTextAreaUI {
	private static final BeOSFocusListener focusListener = new BeOSFocusListener();

	public static ComponentUI createUI(JComponent c) {
		return new BeOSTextAreaUI();
	}

	protected void installListeners() {
		super.installListeners();

		getComponent().addFocusListener(focusListener);
	}

	protected void uninstallListeners() {
		super.uninstallListeners();

		getComponent().removeFocusListener(focusListener);
	}
}
        